/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TrueTypeParser
extends AbstractParser {
    private static final long serialVersionUID = 44788554612243032L;
    private static final MediaType TYPE = MediaType.application("x-font-ttf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.cast(stream);
        if (tis != null) {
            try {
                if (tis.hasFile()) {
                    Font.createFont(0, tis.getFile());
                } else {
                    tis.mark(0);
                    Font.createFont(0, stream);
                    tis.reset();
                }
            }
            catch (FontFormatException ex) {
                throw new TikaException("Bad TrueType font.");
            }
        }
        TTFParser parser = new TTFParser();
        TrueTypeFont font = tis != null && tis.hasFile() ? parser.parseTTF(tis.getFile()) : parser.parseTTF(stream);
        metadata.set("Content-Type", TYPE.toString());
        metadata.set(TikaCoreProperties.CREATED, font.getHeader().getCreated().getTime());
        metadata.set(TikaCoreProperties.MODIFIED, font.getHeader().getModified().getTime());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

