/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.fork.ForkParser;
import org.apache.tika.gui.TikaGUI;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.language.LanguageProfilerBuilder;
import org.apache.tika.language.ProfilingHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.NetworkParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.html.BoilerpipeContentHandler;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.xmp.XMPMetadata;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TikaCLI {
    private File extractDir = new File(".");
    private static final Log logger = LogFactory.getLog(TikaCLI.class);
    private final OutputType XML = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return TikaCLI.getTransformerHandler(output, "xml", TikaCLI.this.encoding, TikaCLI.this.prettyPrint);
        }
    };
    private final OutputType HTML = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new ExpandedTitleContentHandler(TikaCLI.getTransformerHandler(output, "html", TikaCLI.this.encoding, TikaCLI.this.prettyPrint));
        }
    };
    private final OutputType TEXT = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new BodyContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType NO_OUTPUT = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) {
            return new DefaultHandler();
        }
    };
    private final OutputType TEXT_MAIN = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new BoilerpipeContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType METADATA = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentMetHandler(metadata, writer);
        }
    };
    private final OutputType JSON = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentJSONMetHandler(metadata, writer);
        }
    };
    private final OutputType XMP = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentXMPMetaHandler(metadata, writer);
        }
    };
    private final OutputType LANGUAGE = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            final PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new ProfilingHandler(){

                @Override
                public void endDocument() {
                    writer.println(this.getLanguage().getLanguage());
                    writer.flush();
                }
            };
        }
    };
    private final OutputType DETECT = new OutputType(){

        @Override
        public void process(InputStream stream, OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            writer.println(TikaCLI.this.detector.detect(stream, metadata).toString());
            writer.flush();
        }
    };
    private final OutputType CREATE_PROFILE = new OutputType(){

        @Override
        public void process(InputStream stream, OutputStream output, Metadata metadata) throws Exception {
            TikaCLI.this.ngp = LanguageProfilerBuilder.create(TikaCLI.this.profileName, stream, TikaCLI.this.encoding);
            FileOutputStream fos = new FileOutputStream(new File(TikaCLI.this.profileName + ".ngp"));
            TikaCLI.this.ngp.save(fos);
            fos.close();
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            writer.println("ngram profile location:=" + new File(TikaCLI.this.ngp.getName()).getCanonicalPath());
            writer.flush();
        }
    };
    private ParseContext context;
    private Detector detector;
    private Parser parser;
    private OutputType type = this.XML;
    private LanguageProfilerBuilder ngp = null;
    private String encoding = null;
    private String password = System.getenv("TIKA_PASSWORD");
    private boolean pipeMode = true;
    private boolean serverMode = false;
    private boolean fork = false;
    private String profileName = null;
    private boolean prettyPrint;

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure(new WriterAppender((Layout)new SimpleLayout(), System.err));
        Logger.getRootLogger().setLevel(Level.INFO);
        TikaCLI cli = new TikaCLI();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                cli.process(args[i]);
            }
            if (cli.pipeMode) {
                cli.process("-");
            }
        } else {
            if (System.in.available() == 0) {
                Thread.sleep(100L);
            }
            if (System.in.available() > 0) {
                cli.process("-");
            } else {
                cli.process("--gui");
            }
        }
    }

    public TikaCLI() throws Exception {
        this.context = new ParseContext();
        this.detector = new DefaultDetector();
        this.parser = new AutoDetectParser(this.detector);
        this.context.set(Parser.class, this.parser);
        this.context.set(PasswordProvider.class, new PasswordProvider(){

            @Override
            public String getPassword(Metadata metadata) {
                return TikaCLI.this.password;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String arg) throws Exception {
        if (arg.equals("-?") || arg.equals("--help")) {
            this.pipeMode = false;
            this.usage();
        } else if (arg.equals("-V") || arg.equals("--version")) {
            this.pipeMode = false;
            this.version();
        } else if (arg.equals("-v") || arg.equals("--verbose")) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (arg.equals("-g") || arg.equals("--gui")) {
            this.pipeMode = false;
            TikaGUI.main(new String[0]);
        } else if (arg.equals("--list-parser") || arg.equals("--list-parsers")) {
            this.pipeMode = false;
            this.displayParsers(false);
        } else if (arg.equals("--list-detector") || arg.equals("--list-detectors")) {
            this.pipeMode = false;
            this.displayDetectors();
        } else if (arg.equals("--list-parser-detail") || arg.equals("--list-parser-details")) {
            this.pipeMode = false;
            this.displayParsers(true);
        } else if (arg.equals("--list-met-models")) {
            this.pipeMode = false;
            this.displayMetModels();
        } else if (arg.equals("--list-supported-types")) {
            this.pipeMode = false;
            this.displaySupportedTypes();
        } else if (!arg.equals("--container-aware") && !arg.equals("--container-aware-detector")) {
            if (arg.equals("-f") || arg.equals("--fork")) {
                this.fork = true;
            } else if (arg.startsWith("-e")) {
                this.encoding = arg.substring("-e".length());
            } else if (arg.startsWith("--encoding=")) {
                this.encoding = arg.substring("--encoding=".length());
            } else if (arg.startsWith("-p") && !arg.equals("-p")) {
                this.password = arg.substring("-p".length());
            } else if (arg.startsWith("--password=")) {
                this.password = arg.substring("--password=".length());
            } else if (arg.equals("-j") || arg.equals("--json")) {
                this.type = this.JSON;
            } else if (arg.equals("-y") || arg.equals("--xmp")) {
                this.type = this.XMP;
            } else if (arg.equals("-x") || arg.equals("--xml")) {
                this.type = this.XML;
            } else if (arg.equals("-h") || arg.equals("--html")) {
                this.type = this.HTML;
            } else if (arg.equals("-t") || arg.equals("--text")) {
                this.type = this.TEXT;
            } else if (arg.equals("-T") || arg.equals("--text-main")) {
                this.type = this.TEXT_MAIN;
            } else if (arg.equals("-m") || arg.equals("--metadata")) {
                this.type = this.METADATA;
            } else if (arg.equals("-l") || arg.equals("--language")) {
                this.type = this.LANGUAGE;
            } else if (arg.equals("-d") || arg.equals("--detect")) {
                this.type = this.DETECT;
            } else if (arg.startsWith("--extract-dir=")) {
                this.extractDir = new File(arg.substring("--extract-dir=".length()));
            } else if (arg.equals("-z") || arg.equals("--extract")) {
                this.type = this.NO_OUTPUT;
                this.context.set(EmbeddedDocumentExtractor.class, new FileEmbeddedDocumentExtractor());
            } else if (arg.equals("-r") || arg.equals("--pretty-print")) {
                this.prettyPrint = true;
            } else if (arg.equals("-p") || arg.equals("--port") || arg.equals("-s") || arg.equals("--server")) {
                this.serverMode = true;
                this.pipeMode = false;
            } else if (arg.startsWith("-c")) {
                URI uri = new URI(arg.substring("-c".length()));
                this.parser = new NetworkParser(uri);
            } else if (arg.startsWith("--client=")) {
                URI uri = new URI(arg.substring("--client=".length()));
                this.parser = new NetworkParser(uri);
            } else if (arg.startsWith("--create-profile=")) {
                this.profileName = arg.substring("--create-profile=".length());
                this.type = this.CREATE_PROFILE;
            } else {
                this.pipeMode = false;
                if (this.serverMode) {
                    new TikaServer(Integer.parseInt(arg)).start();
                } else {
                    if (arg.equals("-")) {
                        TikaInputStream stream = TikaInputStream.get(new CloseShieldInputStream(System.in));
                        try {
                            this.type.process(stream, System.out, new Metadata());
                        }
                        finally {
                            ((InputStream)stream).close();
                        }
                    }
                    File file = new File(arg);
                    URL url = file.isFile() ? file.toURI().toURL() : new URL(arg);
                    Metadata metadata = new Metadata();
                    TikaInputStream input = TikaInputStream.get(url, metadata);
                    try {
                        this.type.process(input, System.out, metadata);
                    }
                    finally {
                        ((InputStream)input).close();
                        System.out.flush();
                    }
                }
            }
        }
    }

    private void usage() {
        PrintStream out = System.out;
        out.println("usage: java -jar tika-app.jar [option...] [file|port...]");
        out.println();
        out.println("Options:");
        out.println("    -?  or --help          Print this usage message");
        out.println("    -v  or --verbose       Print debug level messages");
        out.println("    -V  or --version       Print the Apache Tika version number");
        out.println();
        out.println("    -g  or --gui           Start the Apache Tika GUI");
        out.println("    -s  or --server        Start the Apache Tika server");
        out.println("    -f  or --fork          Use Fork Mode for out-of-process extraction");
        out.println();
        out.println("    -x  or --xml           Output XHTML content (default)");
        out.println("    -h  or --html          Output HTML content");
        out.println("    -t  or --text          Output plain text content");
        out.println("    -T  or --text-main     Output plain text content (main content only)");
        out.println("    -m  or --metadata      Output only metadata");
        out.println("    -j  or --json          Output metadata in JSON");
        out.println("    -y  or --xmp           Output metadata in XMP");
        out.println("    -l  or --language      Output only language");
        out.println("    -d  or --detect        Detect document type");
        out.println("    -eX or --encoding=X    Use output encoding X");
        out.println("    -pX or --password=X    Use document password X");
        out.println("    -z  or --extract       Extract all attachements into current directory");
        out.println("    --extract-dir=<dir>    Specify target directory for -z");
        out.println("    -r  or --pretty-print  For XML and XHTML outputs, adds newlines and");
        out.println("                           whitespace, for better readability");
        out.println();
        out.println("    --create-profile=X");
        out.println("         Create NGram profile, where X is a profile name");
        out.println("    --list-parsers");
        out.println("         List the available document parsers");
        out.println("    --list-parser-details");
        out.println("         List the available document parsers, and their supported mime types");
        out.println("    --list-detectors");
        out.println("         List the available document detectors");
        out.println("    --list-met-models");
        out.println("         List the available metadata models, and their supported keys");
        out.println("    --list-supported-types");
        out.println("         List all known media types and related information");
        out.println();
        out.println("Description:");
        out.println("    Apache Tika will parse the file(s) specified on the");
        out.println("    command line and output the extracted text content");
        out.println("    or metadata to standard output.");
        out.println();
        out.println("    Instead of a file name you can also specify the URL");
        out.println("    of a document to be parsed.");
        out.println();
        out.println("    If no file name or URL is specified (or the special");
        out.println("    name \"-\" is used), then the standard input stream");
        out.println("    is parsed. If no arguments were given and no input");
        out.println("    data is available, the GUI is started instead.");
        out.println();
        out.println("- GUI mode");
        out.println();
        out.println("    Use the \"--gui\" (or \"-g\") option to start the");
        out.println("    Apache Tika GUI. You can drag and drop files from");
        out.println("    a normal file explorer to the GUI window to extract");
        out.println("    text content and metadata from the files.");
        out.println();
        out.println("- Server mode");
        out.println();
        out.println("    Use the \"--server\" (or \"-s\") option to start the");
        out.println("    Apache Tika server. The server will listen to the");
        out.println("    ports you specify as one or more arguments.");
        out.println();
    }

    private void version() {
        System.out.println(new Tika().toString());
    }

    private void displayMetModels() {
        Class<?>[] modelClasses = Metadata.class.getInterfaces();
        Arrays.sort(modelClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class<?> modelClass : modelClasses) {
            if (modelClass.getSimpleName().contains("Tika")) continue;
            System.out.println(modelClass.getSimpleName());
            Field[] keyFields = modelClass.getFields();
            Arrays.sort(keyFields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Field keyField : keyFields) {
                System.out.println(" " + keyField.getName());
            }
        }
    }

    private void displayParsers(boolean includeMimeTypes) {
        this.displayParser(this.parser, includeMimeTypes, 0);
    }

    private void displayParser(Parser p, boolean includeMimeTypes, int i) {
        boolean isComposite = p instanceof CompositeParser;
        String name = p instanceof ParserDecorator ? ((ParserDecorator)p).getWrappedParser().getClass().getName() : p.getClass().getName();
        System.out.println(this.indent(i) + name + (isComposite ? " (Composite Parser):" : ""));
        if (includeMimeTypes && !isComposite) {
            for (MediaType mt : p.getSupportedTypes(this.context)) {
                System.out.println(this.indent(i + 2) + mt);
            }
        }
        if (isComposite) {
            Parser[] subParsers;
            for (Parser sp : subParsers = this.sortParsers(this.invertMediaTypeMap(((CompositeParser)p).getParsers()))) {
                this.displayParser(sp, includeMimeTypes, i + 2);
            }
        }
    }

    private void displayDetectors() {
        this.displayDetector(this.detector, 0);
    }

    private void displayDetector(Detector d, int i) {
        boolean isComposite = d instanceof CompositeDetector;
        String name = d.getClass().getName();
        System.out.println(this.indent(i) + name + (isComposite ? " (Composite Detector):" : ""));
        if (isComposite) {
            List<Detector> subDetectors = ((CompositeDetector)d).getDetectors();
            for (Detector sd : subDetectors) {
                this.displayDetector(sd, i + 2);
            }
        }
    }

    private String indent(int indent) {
        return "                     ".substring(0, indent);
    }

    private Parser[] sortParsers(Map<Parser, Set<MediaType>> parsers) {
        Parser[] sortedParsers = parsers.keySet().toArray(new Parser[parsers.size()]);
        Arrays.sort(sortedParsers, new Comparator<Parser>(){

            @Override
            public int compare(Parser p1, Parser p2) {
                String name1 = p1.getClass().getName();
                String name2 = p2.getClass().getName();
                return name1.compareTo(name2);
            }
        });
        return sortedParsers;
    }

    private Map<Parser, Set<MediaType>> invertMediaTypeMap(Map<MediaType, Parser> supported) {
        HashMap<Parser, Set<MediaType>> parsers = new HashMap<Parser, Set<MediaType>>();
        for (Map.Entry<MediaType, Parser> e : supported.entrySet()) {
            if (!parsers.containsKey(e.getValue())) {
                parsers.put(e.getValue(), new HashSet());
            }
            ((Set)parsers.get(e.getValue())).add(e.getKey());
        }
        return parsers;
    }

    private void displaySupportedTypes() {
        AutoDetectParser parser = new AutoDetectParser();
        MediaTypeRegistry registry = parser.getMediaTypeRegistry();
        Map<MediaType, Parser> parsers = parser.getParsers();
        for (MediaType type : registry.getTypes()) {
            Parser p;
            System.out.println(type);
            for (MediaType alias : registry.getAliases(type)) {
                System.out.println("  alias:     " + alias);
            }
            MediaType supertype = registry.getSupertype(type);
            if (supertype != null) {
                System.out.println("  supertype: " + supertype);
            }
            if ((p = parsers.get(type)) == null) continue;
            System.out.println("  parser:    " + p.getClass().getName());
        }
    }

    private static Writer getOutputWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            return new OutputStreamWriter(output, "UTF-8");
        }
        return new OutputStreamWriter(output);
    }

    private static TransformerHandler getTransformerHandler(OutputStream output, String method, String encoding, boolean prettyPrint) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", method);
        handler.getTransformer().setOutputProperty("indent", prettyPrint ? "yes" : "no");
        if (encoding != null) {
            handler.getTransformer().setOutputProperty("encoding", encoding);
        }
        handler.setResult(new StreamResult(output));
        return handler;
    }

    private class NoDocumentJSONMetHandler
    extends NoDocumentMetHandler {
        private NumberFormat formatter;
        private Gson gson;

        public NoDocumentJSONMetHandler(Metadata metadata, PrintWriter writer) {
            super(metadata, writer);
            this.formatter = NumberFormat.getInstance();
            this.gson = new Gson();
        }

        @Override
        public void outputMetadata(String[] names) {
            this.writer.print("{ ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    this.writer.println(", ");
                } else {
                    first = false;
                }
                this.gson.toJson((Object)name, (Appendable)this.writer);
                this.writer.print(":");
                this.outputValues(this.metadata.getValues(name));
            }
            this.writer.print(" }");
        }

        public void outputValues(String[] values) {
            if (values.length > 1) {
                this.writer.print("[");
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (i > 0) {
                    this.writer.print(", ");
                }
                if (value == null || value.length() == 0) {
                    this.writer.print("null");
                    continue;
                }
                ParsePosition pos = new ParsePosition(0);
                this.formatter.parse(value, pos);
                if (value.length() == pos.getIndex()) {
                    value = value.replaceFirst("^0+(\\d)", "$1");
                    this.writer.print(value);
                    continue;
                }
                this.gson.toJson((Object)value, (Appendable)this.writer);
            }
            if (values.length > 1) {
                this.writer.print("]");
            }
        }
    }

    private class NoDocumentXMPMetaHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;

        public NoDocumentXMPMetaHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                XMPMetadata xmp = new XMPMetadata(this.metadata);
                String result = xmp.toString();
                this.writer.write(result);
                this.writer.flush();
            }
            catch (TikaException e) {
                throw new SAXException(e);
            }
        }
    }

    private class NoDocumentMetHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;
        private boolean metOutput;

        public NoDocumentMetHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
            this.metOutput = false;
        }

        @Override
        public void endDocument() {
            Object[] names = this.metadata.names();
            Arrays.sort(names);
            this.outputMetadata((String[])names);
            this.writer.flush();
            this.metOutput = true;
        }

        public void outputMetadata(String[] names) {
            for (String name : names) {
                for (String value : this.metadata.getValues(name)) {
                    this.writer.println(name + ": " + value);
                }
            }
        }

        public boolean metOutput() {
            return this.metOutput;
        }
    }

    private class TikaServer
    extends Thread {
        private final ServerSocket server;

        public TikaServer(int port) throws IOException {
            super("Tika server at port " + port);
            this.server = new ServerSocket(port);
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.processSocketInBackground(this.server.accept());
                    }
                }
                catch (Throwable throwable) {
                    this.server.close();
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }

        private void processSocketInBackground(final Socket socket) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            InputStream rawInput = socket.getInputStream();
                            OutputStream output = socket.getOutputStream();
                            TikaInputStream input = TikaInputStream.get(rawInput);
                            TikaCLI.this.type.process(input, output, new Metadata());
                            output.flush();
                        }
                        finally {
                            socket.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    private class FileEmbeddedDocumentExtractor
    implements EmbeddedDocumentExtractor {
        private int count = 0;
        private final TikaConfig config = TikaConfig.getDefaultConfig();

        private FileEmbeddedDocumentExtractor() {
        }

        @Override
        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            File outputFile;
            File parent;
            String relID;
            String name = metadata.get("resourceName");
            if (name == null) {
                name = "file" + this.count++;
            }
            MediaType contentType = TikaCLI.this.detector.detect(inputStream, metadata);
            if (name.indexOf(46) == -1 && contentType != null) {
                try {
                    name = name + this.config.getMimeRepository().forName(contentType.toString()).getExtension();
                }
                catch (MimeTypeException e) {
                    e.printStackTrace();
                }
            }
            if ((relID = metadata.get("embeddedRelationshipId")) != null && !name.startsWith(relID)) {
                name = relID + "_" + name;
            }
            if (!(parent = (outputFile = new File(TikaCLI.this.extractDir, FilenameUtils.normalize(name))).getParentFile()).exists() && !parent.mkdirs()) {
                throw new IOException("unable to create directory \"" + parent + "\"");
            }
            System.out.println("Extracting '" + name + "' (" + contentType + ") to " + outputFile);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(outputFile);
                if (inputStream instanceof TikaInputStream) {
                    TikaInputStream tin = (TikaInputStream)inputStream;
                    if (tin.getOpenContainer() != null && tin.getOpenContainer() instanceof DirectoryEntry) {
                        POIFSFileSystem fs = new POIFSFileSystem();
                        this.copy((DirectoryEntry)tin.getOpenContainer(), fs.getRoot());
                        fs.writeFilesystem(os);
                    } else {
                        IOUtils.copy(inputStream, (OutputStream)os);
                    }
                } else {
                    IOUtils.copy(inputStream, (OutputStream)os);
                }
            }
            catch (Exception e) {
                String msg = String.format("Ignoring unexpected exception trying to save embedded file %s (%s)", name, e.getMessage());
                System.err.println(msg);
                logger.warn(msg, e);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void copy(DirectoryEntry sourceDir, DirectoryEntry destDir) throws IOException {
            for (Entry entry : sourceDir) {
                if (entry instanceof DirectoryEntry) {
                    DirectoryEntry newDir = destDir.createDirectory(entry.getName());
                    this.copy((DirectoryEntry)entry, newDir);
                    continue;
                }
                DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);
                try {
                    destDir.createDocument(entry.getName(), contents);
                }
                finally {
                    ((InputStream)contents).close();
                }
            }
        }
    }

    private class OutputType {
        private OutputType() {
        }

        public void process(InputStream input, OutputStream output, Metadata metadata) throws Exception {
            NoDocumentMetHandler metHandler;
            Parser p = TikaCLI.this.parser;
            if (TikaCLI.this.fork) {
                p = new ForkParser(TikaCLI.class.getClassLoader(), p);
            }
            ContentHandler handler = this.getContentHandler(output, metadata);
            p.parse(input, handler, metadata, TikaCLI.this.context);
            if (handler instanceof NoDocumentMetHandler && !(metHandler = (NoDocumentMetHandler)handler).metOutput()) {
                metHandler.endDocument();
            }
        }

        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

