#!/usr/bin/env bash
#
# Measure the performance between two 'convert' commands by
# executing a subcommand through many iterations and seeing
# the total time that it takes.
#
# Written by Bob Friesenhahn, October 2008
#

# First command (`GM')
convert1='gm convert'

# Second command (ImageMagick)
convert2='convert'

# Input image specification.  We use a tile pattern of a small image
# so that disk I/O is not a factor.  A real file can be used here.
input_image="-size 1920x1080 tile:model.pnm"

# Ouput image specification.  We use "null:" so that disk I/O is not
# a factor.  A real file can be used here.
output_image="null:"

# Number of times to run each algorithm.
iterations=20

# None of the below should require any change.
echo "Convert-1:   ${convert1}"
echo "Version:     `${convert1} -version | head -1`"
echo "Convert-2:   ${convert2}"
echo "Version:     `${convert2} -version | head -1`"
echo "Date:        `date`"
echo "Host:        `uname -n`"
echo "OS:          `uname -s`"
echo "Release:     `uname -r`"
echo "Arch:        `uname -p`"
echo "Input File:  ${input_image}"
echo "Output File: ${output_image}"
echo "Threads:     ${OMP_NUM_THREADS:-1}"
echo "Iterations:  ${iterations}"
echo "========================================================================================"
echo
cat commands.txt | while read subcommand
do
  echo ${subcommand}

  command1="${convert1} ${input_image} ${subcommand} ${output_image}"
  i=1
  count=$iterations
  time while test $i -lt $count
  do
    eval "${command1}"
    let i=i+1
  done
  sleep 1

  command2="${convert2} ${input_image} ${subcommand} ${output_image}"
  i=1
  count=$iterations
  time while test $i -lt $count
  do
    eval "${command2}"
    let i=i+1
  done

  echo
  sleep 1
done

