/* XPENGUINS_APPLET - gnome panel implementation of xpenguins
 * Copyright (C) 1999, 2000  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * XPENGUINS is a kind of a cross between lemmings and xsnow - penguins
 * fall from the top of the screen and walk across the tops of windows.
 * The images are take from `Pingus', a lemmings-type game for Linux.
 * All the nasty X calls are in `toon.c', so xpenguins.c should be easily
 * modifiable to animate any small furry (or feathery) animal of your choice.
 * 
 * XPENGUINS_APPLET is a gnome panel applet that simplifies the launching
 * of penguins on to your root window. It calls functions in xpenguins.c.
 *
 * Robin Hogan <R.J.Hogan@reading.ac.uk>
 * Project started 22 November 1999
 * This file last updated 29 October 2000
 */

#include <config.h>
#include <applet-widget.h>
#include <gdk/gdkx.h>

#include "buttons/sitter_button.xpm"
#include "buttons/play-pause-button.xpm"
#include "buttons/stop-button.xpm"
#include "xpenguins_applet.h"
#include "xpenguins.h"

int
service_xpenguins(gpointer data)
{
  XPenguinData *xp = data;
  int i=1;
  if (xp->paused) {
    xpenguins_pause_frame();
  }
  else {
    xpenguins_frame();
  }
  return i;
}

/*
static gint
toggle_xpenguins(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  if (GTK_TOGGLE_BUTTON(widget)->active) {
    if (!xp->active) {
*/
      /*      gnome_pixmap_load_xpm_d(GNOME_PIXMAP(xp->button_pixmap),
	      walker_button_xpm);*/
/*
      xp->paused = FALSE;
      xpenguins_init(NULL);
      xp->timeout = gtk_timeout_add(1000/xp->speed, service_xpenguins,
				    xp);
      xp->active = TRUE;
    }
  }
  else {
    if (xp->active) {
*/
      /*      gnome_pixmap_load_xpm_d(GNOME_PIXMAP(xp->button_pixmap),
	      sitter_button_xpm);*/
/*
      gtk_timeout_remove(xp->timeout);
      xpenguins_exit();
      xp->active = FALSE;
    }
  }
  return TRUE;
}
*/

static gint
playpause_xpenguins(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  if (!xp->active) {
    xp->paused = FALSE;
    xpenguins_init(NULL);
    xp->timeout = gtk_timeout_add(1000/xp->speed, service_xpenguins,
				  xp);
    xp->active = TRUE;
  }
  else if (xp->paused) {
    xp->paused = FALSE;
  }
  else {
    xp->paused = TRUE;
  }
  return TRUE;
}

static gint
stop_xpenguins(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  if (xp->active) {
    gtk_timeout_remove(xp->timeout);
    xpenguins_exit();
    xp->active = FALSE;
  }
  return TRUE;
}

static void
destroy_xpenguins_widget(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  xpenguins_exit();
  g_free(xp);
}

static void
about (AppletWidget *applet, gpointer data)
{
  static const char *authors[] = { "Robin Hogan <R.J.Hogan@reading.ac.uk>", 
				   NULL };
  GtkWidget *about_box;

  about_box = gnome_about_new (_("XPenguins Applet"),
			       _(VERSION),
			       _("Copyright (C) 2000 "),
			       authors,
			       _("Animates a friendly family of"
				 " penguns in your root window."),
			       NULL);

  gtk_widget_show(about_box);
}

gint
make_pixmap_button(GtkWidget **button, GtkWidget **button_pixmap,
		   char **xpm, gint width, gint height)
{
  *button = gtk_button_new();
  *button_pixmap = gnome_pixmap_new_from_xpm_d(xpm);
  gtk_container_add(GTK_CONTAINER(*button), *button_pixmap);
  GTK_WIDGET_UNSET_FLAGS(*button, GTK_CAN_DEFAULT);
  GTK_WIDGET_UNSET_FLAGS(*button, GTK_CAN_FOCUS);
  gtk_widget_set_usize(GTK_WIDGET(*button), width, height);
  gtk_widget_show(*button_pixmap);
  gtk_widget_show(*button);
  return 0;
}

/*
gint
make_pixmap_toggle_button(GtkWidget **button, GtkWidget **button_pixmap,
			  char **xpm, gint width, gint height)
{
  *button = gtk_toggle_button_new();
  *button_pixmap = gnome_pixmap_new_from_xpm_d(xpm);
  gtk_container_add(GTK_CONTAINER(*button), *button_pixmap);
  GTK_WIDGET_UNSET_FLAGS(*button, GTK_CAN_DEFAULT);
  GTK_WIDGET_UNSET_FLAGS(*button, GTK_CAN_FOCUS);
  gtk_widget_set_usize(GTK_WIDGET(*button), width, height);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(*button),0);
  gtk_widget_show(*button_pixmap);
  gtk_widget_show(*button);
  return 0;
}
*/

int
main (int argc, char **argv)
{
  XPenguinData *xp;
  GtkWidget *applet;
  GtkTooltips *tooltip;

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

  applet_widget_init("xpenguins_applet", VERSION, argc,
		     argv, NULL, 0, NULL);
  applet = applet_widget_new("xpenguins_applet");
  if (!applet)
    g_error (_("Can't create xpenguins applet!"));

  xp = g_new(XPenguinData,1);
  make_pixmap_button(&(xp->button),
		     &(xp->button_pixmap), sitter_button_xpm, 36, 32);
  xp->prop_window = NULL;
  xp->active = 0;
  xp->number = 10;
  xp->speed = 20;
  xp->ignorepopups = FALSE;
  xpenguins_set_number(xp->number);
  xpenguins_ignorepopups((char) xp->ignorepopups);

  gtk_signal_connect(GTK_OBJECT(applet),"destroy",
		     GTK_SIGNAL_FUNC(destroy_xpenguins_widget),
		     xp);
  /*  gtk_signal_connect(GTK_OBJECT(xp->button),"toggled",
      GTK_SIGNAL_FUNC(toggle_xpenguins),
      xp);*/
  /* gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(xp->button),0);*/

  applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					"properties",
					GNOME_STOCK_MENU_PROP,
					_("Properties..."),
					property_show,
					xp);
  applet_widget_register_stock_callback(APPLET_WIDGET (applet),
					"about",
					GNOME_STOCK_MENU_ABOUT,
					_("About..."),
					about,
					NULL);

  xp->vbox = gtk_vbox_new(FALSE,0);
  xp->hbox = gtk_hbox_new(FALSE,0);

  make_pixmap_button(&(xp->stop), &(xp->stop_pixmap),
		     stop_xpm, 15, 16);
  make_pixmap_button(&(xp->playpause), &(xp->playpause_pixmap),
		     play_pause_xpm, 28, 15);

  gtk_signal_connect(GTK_OBJECT(xp->button),"clicked",
		     GTK_SIGNAL_FUNC(property_show), xp);
  gtk_signal_connect(GTK_OBJECT(xp->playpause),"clicked",
		     GTK_SIGNAL_FUNC(playpause_xpenguins), xp);
  gtk_signal_connect(GTK_OBJECT(xp->stop),"clicked",
		     GTK_SIGNAL_FUNC(stop_xpenguins), xp);

  gtk_box_pack_start(GTK_BOX(xp->vbox),xp->button, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(xp->vbox),xp->hbox, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(xp->hbox),xp->stop, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(xp->hbox),xp->playpause, FALSE, FALSE, 0);

  gtk_widget_show(xp->vbox);
  gtk_widget_show(xp->hbox);

  applet_widget_add(APPLET_WIDGET(applet), xp->vbox);

  tooltip = gtk_tooltips_new();
  gtk_tooltips_set_tip(tooltip, applet, "XPenguins controller", NULL);

  gtk_widget_realize(applet);
  gtk_widget_show(applet);
  applet_widget_gtk_main ();
  return 0;
}

