/* def.h - defines penguin image data for use by xpenguins
 * Copyright (C) 1999, 2000  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define PENGUIN_FORWARD 0
#define PENGUIN_LEFTRIGHT 1
#define PENGUIN_LEFT 0
#define PENGUIN_RIGHT 1

#define PENGUIN_WALKER 0
#define PENGUIN_FALLER 1
#define PENGUIN_TUMBLER 2
#define PENGUIN_FLOATER 3
#define PENGUIN_CLIMBER 4
#define PENGUIN_BOMBER 5
#define PENGUIN_EXPLOSION 6
#define PENGUIN_TYPES 7

#define PENGUIN_DEFAULTWIDTH 30
#define PENGUIN_DEFAULTHEIGHT 30

#include "walker.xpm"
#include "faller.xpm"
#include "tumbler.xpm"
#include "floater.xpm"
#include "climber.xpm"
#include "bomber.xpm"
#include "explosion.xpm"
/*#include "hearts.xpm"*/

ToonData penguin_data[] = {
   { walker_xpm, 8, 2, 30, 30, TOON_DEFAULTS },
   { faller_xpm, 8, 1, 30, 30, TOON_DEFAULTS },
   { tumbler_xpm, 8, 1, 30, 30, TOON_DEFAULTS },
   { floater_xpm, 8, 1, 30, 30, TOON_DEFAULTS },
   { climber_xpm, 8, 2, 30, 30, TOON_DEFAULTS },
   /*   { hearts_xpm, 20, 1, 36, 36, TOON_NOCYCLE },*/
   { bomber_xpm, 16, 1, 32, 32, TOON_NOCYCLE },
   { explosion_xpm, 1, 1, 64, 64, TOON_NOCYCLE }
};
