
#include <string.h>
#include <glib.h>
#include <pan/base/gnksa.h>
#include <pan/base/pan-glib-extensions.h>

typedef struct 
{
	int expected_retval;
	const char * address;
}
AddressCheck;

typedef struct
{
	int len;
	const char * in;
	const char * expected_out;
}
ReferencesCheck;

static ReferencesCheck references [] =
{
	{
		998, /*  gnksa cutoff */

		"<gnksa_pan-0.8.0_001@lull.org>"
		" <gnksa_pan-0.8.0_002@lull.org> <gnksa_pan-0.8.0_003@lull.org>"
		" <gnksa_pan-0.8.0_004@lull.org> <gnksa_pan-0.8.0_005@lull.org>"
		" <gnksa_pan-0.8.0_006@lull.org> <gnksa_pan-0.8.0_007@lull.org>"
		" <gnksa_pan-0.8.0_008@lull.org> <gnksa_pan-0.8.0_009@lull.org>"
		" <gnksa_pan-0.8.0_010@lull.org> <gnksa_pan-0.8.0_011@lull.org>"
		" <gnksa_pan-0.8.0_012@lull.org> <gnksa_pan-0.8.0_013@lull.org>"
		" <gnksa_pan-0.8.0_014@lull.org> <gnksa_pan-0.8.0_015@lull.org>"
		" <gnksa_pan-0.8.0_016@lull.org> <gnksa_pan-0.8.0_017@lull.org>"
		" <gnksa_pan-0.8.0_018@lull.org> <gnksa_pan-0.8.0_019@lull.org>"
		" <gnksa_pan-0.8.0_020@lull.org> <gnksa_pan-0.8.0_021@lull.org>"
		" <gnksa_pan-0.8.0_022@lull.org> <gnksa_pan-0.8.0_023@lull.org>"
		" <gnksa_pan-0.8.0_024@lull.org> <gnksa_pan-0.8.0_025@lull.org>"
		" <gnksa_pan-0.8.0_026@lull.org> <gnksa_pan-0.8.0_027@lull.org>"
		" <gnksa_pan-0.8.0_028@lull.org> <gnksa_pan-0.8.0_029@lull.org>"
		" <gnksa_pan-0.8.0_030@lull.org> <gnksa_pan-0.8.0_031@lull.org>"
  		" <gnksa_pan-0.8.0_035.12345@lull.org>",

		"<gnksa_pan-0.8.0_001@lull.org>"
		" <gnksa_pan-0.8.0_002@lull.org> <gnksa_pan-0.8.0_003@lull.org>"
		" <gnksa_pan-0.8.0_004@lull.org> <gnksa_pan-0.8.0_005@lull.org>"
		" <gnksa_pan-0.8.0_006@lull.org> <gnksa_pan-0.8.0_007@lull.org>"
		" <gnksa_pan-0.8.0_008@lull.org> <gnksa_pan-0.8.0_009@lull.org>"
		" <gnksa_pan-0.8.0_010@lull.org> <gnksa_pan-0.8.0_011@lull.org>"
		" <gnksa_pan-0.8.0_012@lull.org> <gnksa_pan-0.8.0_013@lull.org>"
		" <gnksa_pan-0.8.0_014@lull.org> <gnksa_pan-0.8.0_015@lull.org>"
		" <gnksa_pan-0.8.0_016@lull.org> <gnksa_pan-0.8.0_017@lull.org>"
		" <gnksa_pan-0.8.0_018@lull.org> <gnksa_pan-0.8.0_019@lull.org>"
		" <gnksa_pan-0.8.0_020@lull.org> <gnksa_pan-0.8.0_021@lull.org>"
		" <gnksa_pan-0.8.0_022@lull.org> <gnksa_pan-0.8.0_023@lull.org>"
		" <gnksa_pan-0.8.0_024@lull.org> <gnksa_pan-0.8.0_025@lull.org>"
		" <gnksa_pan-0.8.0_026@lull.org> <gnksa_pan-0.8.0_027@lull.org>"
		" <gnksa_pan-0.8.0_028@lull.org> <gnksa_pan-0.8.0_029@lull.org>"
		" <gnksa_pan-0.8.0_030@lull.org> <gnksa_pan-0.8.0_031@lull.org>"
  		" <gnksa_pan-0.8.0_035.12345@lull.org>"
	},
	{
		998, /*  gnksa cutoff */

		"<gnksa_pan-0.8.0_001@lull.org>"
		" <gnksa_pan-0.8.1_001@lull.org>"
		" <gnksa_pan-0.8.0_002@lull.org> <gnksa_pan-0.8.0_003@lull.org>"
		" <gnksa_pan-0.8.0_004@lull.org> <gnksa_pan-0.8.0_005@lull.org>"
		" <gnksa_pan-0.8.0_006@lull.org> <gnksa_pan-0.8.0_007@lull.org>"
		" <gnksa_pan-0.8.0_008@lull.org> <gnksa_pan-0.8.0_009@lull.org>"
		" <gnksa_pan-0.8.0_010@lull.org> <gnksa_pan-0.8.0_011@lull.org>"
		" <gnksa_pan-0.8.0_012@lull.org> <gnksa_pan-0.8.0_013@lull.org>"
		" <gnksa_pan-0.8.0_014@lull.org> <gnksa_pan-0.8.0_015@lull.org>"
		" <gnksa_pan-0.8.0_016@lull.org> <gnksa_pan-0.8.0_017@lull.org>"
		" <gnksa_pan-0.8.0_018@lull.org> <gnksa_pan-0.8.0_019@lull.org>"
		" <gnksa_pan-0.8.0_020@lull.org> <gnksa_pan-0.8.0_021@lull.org>"
		" <gnksa_pan-0.8.0_022@lull.org> <gnksa_pan-0.8.0_023@lull.org>"
		" <gnksa_pan-0.8.0_024@lull.org> <gnksa_pan-0.8.0_025@lull.org>"
		" <gnksa_pan-0.8.0_026@lull.org> <gnksa_pan-0.8.0_027@lull.org>"
		" <gnksa_pan-0.8.0_028@lull.org> <gnksa_pan-0.8.0_029@lull.org>"
		" <gnksa_pan-0.8.0_030@lull.org> <gnksa_pan-0.8.0_031@lull.org>"
  		" <gnksa_pan-0.8.0_035.12345@lull.org>",

		"<gnksa_pan-0.8.0_001@lull.org>"
		" <gnksa_pan-0.8.0_002@lull.org> <gnksa_pan-0.8.0_003@lull.org>"
		" <gnksa_pan-0.8.0_004@lull.org> <gnksa_pan-0.8.0_005@lull.org>"
		" <gnksa_pan-0.8.0_006@lull.org> <gnksa_pan-0.8.0_007@lull.org>"
		" <gnksa_pan-0.8.0_008@lull.org> <gnksa_pan-0.8.0_009@lull.org>"
		" <gnksa_pan-0.8.0_010@lull.org> <gnksa_pan-0.8.0_011@lull.org>"
		" <gnksa_pan-0.8.0_012@lull.org> <gnksa_pan-0.8.0_013@lull.org>"
		" <gnksa_pan-0.8.0_014@lull.org> <gnksa_pan-0.8.0_015@lull.org>"
		" <gnksa_pan-0.8.0_016@lull.org> <gnksa_pan-0.8.0_017@lull.org>"
		" <gnksa_pan-0.8.0_018@lull.org> <gnksa_pan-0.8.0_019@lull.org>"
		" <gnksa_pan-0.8.0_020@lull.org> <gnksa_pan-0.8.0_021@lull.org>"
		" <gnksa_pan-0.8.0_022@lull.org> <gnksa_pan-0.8.0_023@lull.org>"
		" <gnksa_pan-0.8.0_024@lull.org> <gnksa_pan-0.8.0_025@lull.org>"
		" <gnksa_pan-0.8.0_026@lull.org> <gnksa_pan-0.8.0_027@lull.org>"
		" <gnksa_pan-0.8.0_028@lull.org> <gnksa_pan-0.8.0_029@lull.org>"
		" <gnksa_pan-0.8.0_030@lull.org> <gnksa_pan-0.8.0_031@lull.org>"
  		" <gnksa_pan-0.8.0_035.12345@lull.org>"
	},
	{
		1024,

		"<gnksa.01@lull.org> <lull.org> <gnksa.03> <@lull.org>"
		" <gnksa.05@> <gnksa.06@lull.org> <>"
		" <gnksa.08@lull.org> <gnksa.09@lull.org"
		" <gnksa.10@lull.org> gnksa.11@lull.org>"
		" <gnksa.12@@lull.org> <gnksa.13@lull.org>.14@lull.org>"
		" gnksa.15@lull.org <gnksa.16@lull.org>",

		"<gnksa.01@lull.org> <gnksa.06@lull.org>"
		" <gnksa.08@lull.org> <gnksa.10@lull.org>"
		" <gnksa.13@lull.org>"
		" <gnksa.16@lull.org>"
	},
	{
		1024,

		"<a@b.a> <d@f.uk> <postmaster@l.uk> <n@o.uk> <@bar.uk>"
		" <foo@bar.com><baz@xyzzy.org> <foo@> <foo@"
		" <blah@trala> <blah@trala.org>",

		"<a@b.a> <d@f.uk> <n@o.uk> <foo@bar.com>"
		" <baz@xyzzy.org> <blah@trala> <blah@trala.org>"
	},
	{
		36,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <k@l.uk> <n@o.uk> <q@r.uk>"
	},
	{
		35,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <k@l.uk> <n@o.uk> <q@r.uk>"
	},
	{
		34,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <n@o.uk> <q@r.uk>"
	},
	{
		32,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <n@o.uk> <q@r.uk>",
	},
	{
		27,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <n@o.uk> <q@r.uk>",
	},
	{
		26,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <n@o.uk> <q@r.uk>",
	},
	{
		25,
		"<a@b.uk> <d@f.uk> <h@i.uk> <k@l.uk> <n@o.uk> <q@r.uk>",
		"<a@b.uk> <q@r.uk>",
	},
};

static AddressCheck addresses [] =
{
	{ GNKSA_ILLEGAL_PLAIN_PHRASE, "Charles S. Kerr <charles@foo.com>" },
	{ GNKSA_OK, "\"Charles S. Kerr\" <charles@foo.com>" },
	{ GNKSA_OK, "charles kerr <charles@superpimp.org>" },
	{ GNKSA_OK, "Charles \"Pan Programmer\" Kerr <charles@superpimp.org>" },
	{ GNKSA_OK, "Charles \"Likes, to, put, commas, in, quoted, strings\" Kerr <charles@superpimp.org>" },
	{ GNKSA_OK, "\"Charles Kerr, Pan Programmer\" <charles@superpimp.org>" },
	{ GNKSA_ILLEGAL_PLAIN_PHRASE, "Charles Kerr, Pan Programmer <charles@superpimp.org>" },
	{ GNKSA_INVALID_DOMAIN, "charles kerr <charles>" },
	{ GNKSA_OK, "charles@superpimp.org" },
	{ GNKSA_OK, "charles@superpimp.org (Charles Kerr)" },
	{ GNKSA_SINGLE_DOMAIN, "Charles Kerr <charles@org>" },
	{ GNKSA_SINGLE_DOMAIN, "Charles Kerr <@org>" },
	{ GNKSA_OK, "Charles Kerr <charles@[127.0.0.1]>" },
	{ GNKSA_BAD_DOMAIN_LITERAL, "Charles Kerr <charles@[127..0.1]>" },
	{ GNKSA_BAD_DOMAIN_LITERAL, "Charles Kerr <charles@[127...1]>" },
	{ GNKSA_BAD_DOMAIN_LITERAL, "Charles Kerr <charles@[127.0.0.]>" },
	{ GNKSA_ZERO_LENGTH_LABEL, "<charles@pimp.org.>" },
	{ GNKSA_ILLEGAL_LABEL_HYPHEN, "<charles@pimp-.org>" },
	{ GNKSA_OK, "<charles@pimp.org>" },
	{ GNKSA_OK, "Charles <charles@pimp.asf.fa>" },
	{ GNKSA_OK, "Charles <charles@pimp.asf.uk>" },
	{ GNKSA_ZERO_LENGTH_LABEL, "<charles@>" },
	{ GNKSA_LOCALPART_MISSING, "<@pimp.org>" },
	{ GNKSA_OK, "Charles Kerr <charles@skywalker.ecn.ou.edu>" },
	{ GNKSA_LPAREN_MISSING, "Charles Kerr" },
	{ GNKSA_OK, "looniii@aol.com (Looniii)" },
	{ GNKSA_OK, "Eric <scare.crow@oz.land>" }
};

int
main (void)
{
	/* test addresses */
	if (1)
	{
		gint i;
		gint qty = sizeof(addresses) / sizeof(addresses[0]);
		for (i=0; i!=qty; ++i) {
			const gint retval = gnksa_check_from (addresses[i].address, TRUE);
			if (retval!=addresses[i].expected_retval) return i+1;
		}
		g_message ("PASS email address parsing");
	}

	/* test trimming */
	if (1)
	{
		gint i;
		gint qty = sizeof(references) / sizeof(references[0]);
		for (i=0; i!=qty; ++i) {
			gchar * pch = gnksa_trim_references_to_len (references[i].in, references[i].len);
			if (strcmp(references[i].expected_out, pch)) return 100 + i+1;
			g_free (pch);
		}
		g_message ("PASS trimming references strings");
	}


	/* test message-id generation */
	if (1)
	{
		gchar * id1;
		gchar * id2;

		id1 = gnksa_generate_message_id_from_email_addr ("<foo@bar.com>");
		id2 = gnksa_generate_message_id_from_email_addr ("<foo@bar.com>");
		if (!is_nonempty_string(id1)) return 1;
		if (!is_nonempty_string(id2)) return 1;
		g_free (id1);
		g_free (id2);

		id1 = gnksa_generate_message_id_from_email_addr ("Joe <joe@bar.com>");
		g_message ("[%s]", id1);
		if (!is_nonempty_string(id1)) return 1;
		if (!strstr(id1,"bar")) return 1;
		g_free (id1);

		id1 = gnksa_generate_message_id_from_email_addr ("zzz.com");
		g_message ("[%s]", id1);
		if (!is_nonempty_string(id1)) return 1;
		if (!strstr(id1,"zzz")) return 1;
		g_free (id1);

		id1 = gnksa_generate_message_id_from_email_addr ("@bar.com>");
		g_message ("[%s]", id1);
		if (!is_nonempty_string(id1)) return 1;
		if (!strstr(id1,"bar")) return 1;
		g_free (id1);

		g_message ("PASS gnksa_generate_message_id_from_email_addr");
	}

	g_message ("All GNKSA tests passed");

	return 0;
}
