/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * dialog-about.c: About dialog
 */

#include <config.h>
#include <libgnomeui/libgnomeui.h>
#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static gchar * get_credits_code (void);
static gchar * get_credits_users (void);
static gchar * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	gchar * pch;
	gchar * credits_bugs;
	gchar * credits_i18n;
	gchar * credits_code;
	GtkWidget * w;
	PanAbout * a;

	static GtkWidget * about = NULL;

	w = pan_about_new ("Pan",
	                   VERSION,
	                   _("A newsreader for GNOME"),
	                   _("Copyright (C) 1999-2001, Pan Development Team"),
	                   PAN_ABOUT_LICENSE_GPL,
	                   "http://pan.rebelbase.com/");

	a = PAN_ABOUT(w);
	pan_about_add_author (a, "Charles Kerr", "charles@rebelbase.com",
	                      _("Lead Programmer"));
	pan_about_add_author (a, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (a, "Adam Huffman", "bloch@verdurin.com",
	                      _("Programmer & Documentation"));
	pan_about_add_author (a, "Tov are Jacobsen", "tovj@stud.ntnu.no",
	                      _("Translation Coordinator"));
	pan_about_add_author (a, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (a, "Jason Leach", "jleach@ximian.com",
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Many thanks to the following people, whose contributions\n"
	                         "are a large part of why Open Source software development\n"
	                         "is so fun.\n"
                                 "\n"
                                 "Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
                                 "If you should have been in this list but you're not,\n"
                                 "send us mail and we'll add you next time.\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (a, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_signal_connect (GTK_OBJECT(w), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			    &about);

	if (window != NULL)
		gnome_dialog_set_parent (GNOME_DIALOG(w),
					 GTK_WINDOW (window));

	gtk_widget_show (w);
}


static gchar *
get_credits_translators (void)
{
	return g_strdup ("\n\tAntonio de la Torre \n\tJarmo Kielosto \n\tAndrs Tmr \n\tMarcel Telka \n\tChristian Rose");
}

static gchar *
get_credits_code (void)
{
	return g_strdup ("\n\tVolodymyr M . Lisivka\n\tFredrik Pettersson\n\tMike Robinson\n\tOwen Taylor");
}

static gchar *
get_credits_users (void)
{
	return g_strdup ("\n\tAnubis \n\tJed S. Baer \n\tGavin Baker \n\tSteven Behnke \n\tAdrian Von Bidder \n\tCN \n\tDuncan Coutts \n\tRyan Daniels \n\tTrey Egan \n\tPaolo Fiore \n\tJim Henderson \n\tDave Hill \n\tPhilip Van Hoof \n\tSimon Jester \n\tFrancesco Lamonica \n\tLenny \n\tShawn Lindsay \n\tToralf Lund \n\tMatt \n\tmdew \n\tJohn Mellor \n\tDavid Oberbeck \n\tHuub Reuver \n\tNoah Romer \n\tB J Rosen \n\tAlan Schmidt \n\tFlorian Schmidt \n\tT'aZ \n\tClark Tompsett \n\tWilliam Shotts \n\tDavid Stuart \n\tSam Simpson \n\tC Sullivan \n\tJohn Summerfield \n\tTester \n\tMystic Zen Biker Twigboy \n\tWanderer \n\tAndy Zbikowski \n\tTaylor James Zingsheim");
}
