# -*- coding: utf-8 -*-

# Copyright (C) 2004-2006 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys

import ontv.keybinder

class KeyBinder:
    def __init__(self, config):
        self.config = config

        self.show_window_hotkey = None
        self.show_search_program_hotkey = None

    def bind(self, key, callback, *data):
        try:
            ontv.keybinder.tomboy_keybinder_bind(key, callback, *data)
            if self.config.debug:
                print "Binded key \"%s\" to function %s." % (key, callback)
        except KeyError, ke:
            print >> sys.stderr, ke

    def unbind(self, key):
        try:
            ontv.keybinder.tomboy_keybinder_unbind(key)
            if self.config.debug:
                print "Unbinded key \"%s\"." % (key)
        except KeyError, ke:
            print >> sys.stderr, ke

# vim: set sw=4 et sts=4 tw=79 fo+=l:
