/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:32 EDT
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;

/**
 * A PangoTabArray struct contains an array of tab stops. Each tab stop has an
 * alignment and a position.
 */
public class TabArray extends Boxed 
{

	/**
	 * Constructs new Tab array from handle to native resources. Used internally
	 * by Java-Gnome.
	 */
	public TabArray(int handle){
		this.handle = handle;
	}


	/**
	 * Creates an array of <code>initialSize</code> tab stops. Tab stops are
	 * specified in pixel units if <code>positionsInPixels<code> is
	 * <code>true</code>, otherwise in Pango units. All stops are initially at
	 * position 0.
	 */
	public TabArray(int initialSize, boolean positionsInPixels){
		handle = pango_tab_array_new(initialSize, positionsInPixels);
	}

	/**
	 * Get the number of tab stops in the array
	 */
	public int getSize(){
		return pango_tab_array_get_size(handle);
	}

	/**
	 * Resizes a tab array. You must subsequently initialize any tabs that were
	 * added as a result of growing the array.
	 */
	public void resize(int newSize){
		pango_tab_array_resize(handle, newSize);
	}

	/**
	 * Sets the alignment and location of a tab stop. Alignment must always be
	 * {@link TabAlign#LEFT} in the current implementation.
	 * @param tabIndex The index of a tab stop
	 * @param alignment Tab alignment
	 * @param location Tab location in pango units
	 */
	public void setTab(int tabIndex, TabAlign alignment, int location){
		pango_tab_array_set_tab(handle, tabIndex, alignment.getValue(), location);
	}

	/**
	 * Returns the position of the tab stops
	 */
	public int getPosition(int tabIndex){
		return pango_tab_array_get_tabLocation(handle, tabIndex);
	}

	/**
	 * Returns the alignment ofthe tab stop
	 */
	public TabAlign getAligment(int tabIndex){
		return TabAlign.intern( pango_tab_array_get_tabAlignment(handle, tabIndex));
	}

    native static final protected int pango_tab_array_get_tabLocation (int tabArray, int tabIndex);
    native static final protected int pango_tab_array_get_tabAlignment (int tabArray, int tabIndex);
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_tab_array_new (int initialSize, boolean 
        positionInPixels);
    native static final protected int pango_tab_array_get_type ();
    native static final protected int pango_tab_array_copy (int src);
    native static final protected void pango_tab_array_free (int tabArray);
    native static final protected int pango_tab_array_get_size (int tabArray);
    native static final protected void pango_tab_array_resize (int tabArray, int newSize);
    native static final protected void pango_tab_array_set_tab (int tabArray, int tabIndex, int 
        alignment, int location);
    native static final protected void pango_tab_array_get_tab (int tabArray, int tabIndex, int 
        alignment, int [] location);
    native static final protected boolean pango_tab_array_get_positions_in_pixels (int tabArray);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

