/*
 * LibGTcpSocket: libgtcpsocket/gtcp-i18n.h
 *
 * Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation
 * Copyright (C) 2002 James M. Cape
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GTCP_I18N_H__
#define __GTCP_I18N_H__ 1

#include <glib.h>

G_BEGIN_DECLS


#ifdef ENABLE_NLS
#	include <libintl.h>
#	ifdef HAVE_GETTEXT
#		define _(String) gettext (String)
#	else
#		define _(String) (String)
#	endif /* HAVE_GETTEXT */
#	ifndef gettext_noop
#		define gettext_noop(String) (String)
#	endif /* gettext_noop */
#	define N_(String) gettext_noop (String)
#else
/* Stubs that do something close enough.  */
#	define textdomain(String) (String)
#	define gettext(String) (String)
#	define dgettext(Domain,Message) (Message)
#	define dcgettext(Domain,Message,Type) (Message)
#	define bindtextdomain(Domain,Directory) (Domain)
#	define _(String) (String)
#	define N_(String) (String)
#endif


G_END_DECLS

#endif /* __GTCP_I18N_H__ */
