
#include <libgnomeuimm/file-entry.h>
#include <libgnomeuimm/private/file-entry_p.h>

/* $Id: file-entry.ccg,v 1.7 2002/01/03 12:28:01 murrayc Exp $ */


/* file-entry.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnome-file-entry.h>

namespace Gnome
{

namespace UI
{

FileEntry::FileEntry(const Glib::ustring& history_id,
				 const Glib::ustring& browse_dialog_title)
  : Gtk::HBox(GTK_HBOX(g_object_new(get_type(),0)))
{
  gnome_file_entry_construct(gobj(),
			     history_id.c_str(),
			     browse_dialog_title.c_str());
}

} /* namespace UI */
} /* namespace Gnome */ 


namespace
{

const Glib::SignalProxyInfo FileEntry_signal_browse_clicked_info =
{
  "browse_clicked",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo FileEntry_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::FileEntry* wrap(GnomeFileEntry* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::FileEntry *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType FileEntry_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_file_entry_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Gtk::Editable::add_interface(get_type());
  }

  return gtype_;
}

void FileEntry_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->browse_clicked = &browse_clicked_callback;
  klass->activate = &activate_callback;
}


void FileEntry_Class::browse_clicked_callback(GnomeFileEntry* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_browse_clicked();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->browse_clicked)
      (*base->browse_clicked)(self);
  }
}

void FileEntry_Class::activate_callback(GnomeFileEntry* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate)
      (*base->activate)(self);
  }
}


Glib::ObjectBase* FileEntry_Class::wrap_new(GObject* o)
{
  return manage(new FileEntry((GnomeFileEntry*)(o)));
}


/* The implementation: */

FileEntry::FileEntry(GnomeFileEntry* castitem)
: Gtk::HBox((GtkHBox*)(castitem))
{}

FileEntry::~FileEntry()
{
  destroy_();
}

FileEntry::CppClassType FileEntry::fileentry_class_; //Initialize static member.

GType FileEntry::get_type()
{
  return fileentry_class_.get_type();
}

GType FileEntry::get_base_type()
{
  return gnome_file_entry_get_type();
}

FileEntry::FileEntry()
: Gtk::HBox((GtkHBox*)(g_object_new(get_type(), (char*)0)))
{}

Gtk::Widget* FileEntry::gnome_entry()
{
  return Glib::wrap(gnome_file_entry_gnome_entry(gobj()));
}

Gtk::Widget* FileEntry::gtk_entry()
{
  return Glib::wrap(gnome_file_entry_gtk_entry(gobj()));
}

void FileEntry::set_title(const Glib::ustring& browse_dialog_title)
{
  gnome_file_entry_set_title(gobj(), browse_dialog_title.c_str());
}

void FileEntry::set_default_path(const Glib::ustring& path)
{
  gnome_file_entry_set_default_path(gobj(), path.c_str());
}

void FileEntry::set_directory_entry(bool directory_entry)
{
  gnome_file_entry_set_directory_entry(gobj(), static_cast<int>(directory_entry));
}

bool FileEntry::get_directory_entry() const
{
  return gnome_file_entry_get_directory_entry(const_cast<GnomeFileEntry*>(gobj()));
}

Glib::ustring FileEntry::get_full_path(bool file_must_exist) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_file_entry_get_full_path(const_cast<GnomeFileEntry*>(gobj()), static_cast<int>(file_must_exist)));
}

void FileEntry::set_filename(const Glib::ustring& filename)
{
  gnome_file_entry_set_filename(gobj(), filename.c_str());
}

void FileEntry::set_modal(bool is_modal)
{
  gnome_file_entry_set_modal(gobj(), static_cast<int>(is_modal));
}

bool FileEntry::get_modal() const
{
  return gnome_file_entry_get_modal(const_cast<GnomeFileEntry*>(gobj()));
}


Glib::SignalProxy0<void> FileEntry::signal_browse_clicked()
{
  return Glib::SignalProxy0<void>(this, &FileEntry_signal_browse_clicked_info);
}

Glib::SignalProxy0<void> FileEntry::signal_activate()
{
  return Glib::SignalProxy0<void>(this, &FileEntry_signal_activate_info);
}


void Gnome::UI::FileEntry::on_browse_clicked()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->browse_clicked)
    (*base->browse_clicked)(gobj());
}

void Gnome::UI::FileEntry::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate)
    (*base->activate)(gobj());
}


} // namespace UI

} // namespace Gnome

