
#include <libgnomeuimm/druid.h>
#include <libgnomeuimm/private/druid_p.h>

/* $Id: druid.ccg,v 1.8 2002/04/27 20:24:50 murrayc Exp $ */


/* druid.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace UI
{

namespace Druid_Helpers
{
/*
GList*& PageList::glist() const
{
  return parent_->children;
}


PageList::iterator PageList::insert(iterator i, DruidPage& e)
{
  if (i != end())
  {
    gnome_druid_insert_page(parent_, (*i)->gobj(), e.gobj());
    return ++i;
  }

  push_back(e);
  return --end();
}

void PageList::push_front(DruidPage& e)
{
  gnome_druid_prepend_page(parent_,e.gobj());
}

void PageList::push_back(DruidPage& e)
{
  gnome_druid_append_page(parent_,e.gobj());
}

void PageList::remove(DruidPage &w)
{
  gtk_container_remove((GtkContainer*)parent_,(GtkWidget*)(w.gobj()));
}

PageList::iterator PageList::erase(iterator position)
{
  if (!position.node || position == end())
    return end();

  iterator next = position;
  next++;

  gtk_container_remove((GtkContainer*)parent_, (GtkWidget*)((*position)->gobj()));

  return next;
}

void PageList::erase(iterator start, iterator stop)
{
  while(start != stop)
    start = erase(start);
}

void PageList::clear()
{
  erase(begin(), end());
}

PageList::value_type PageList::operator[](size_type l) const
{
  size_type j = 0;
  iterator i;
  for (i = begin(), j = 0; i != end(), j < l; ++i, ++j);
  return (*i);
}

PageList::iterator PageList::begin_() const
{
  return iterator(glist(), glist());
}

PageList::iterator PageList::end_() const
{
  return iterator(glist(), (GList*)0);
}

PageList::size_type PageList::size() const
{
  return g_list_length(glist());
}
*/


} /* namespace Druid_Helpers */
} /* namespace UI */
} /* namespace Gnome */


namespace
{

const Glib::SignalProxyInfo Druid_signal_cancel_info =
{
  "cancel",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Druid_signal_help_info =
{
  "help",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::Druid* wrap(GnomeDruid* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::Druid *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType Druid_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_druid_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Druid_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->cancel = &cancel_callback;
  klass->help = &help_callback;
}


void Druid_Class::cancel_callback(GnomeDruid* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_cancel();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cancel)
      (*base->cancel)(self);
  }
}

void Druid_Class::help_callback(GnomeDruid* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_help();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->help)
      (*base->help)(self);
  }
}


Glib::ObjectBase* Druid_Class::wrap_new(GObject* o)
{
  return manage(new Druid((GnomeDruid*)(o)));
}


/* The implementation: */

Druid::Druid(GnomeDruid* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Druid::~Druid()
{
  destroy_();
}

Druid::CppClassType Druid::druid_class_; //Initialize static member.

GType Druid::get_type()
{
  return druid_class_.get_type();
}

GType Druid::get_base_type()
{
  return gnome_druid_get_type();
}

Druid::Druid()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

void Druid::set_buttons_sensitive(bool back_sensitive, bool next_sensitive, bool cancel_sensitive, bool help_sensitive)
{
  gnome_druid_set_buttons_sensitive(gobj(), static_cast<int>(back_sensitive), static_cast<int>(next_sensitive), static_cast<int>(cancel_sensitive), static_cast<int>(help_sensitive));
}

void Druid::set_show_finish(bool show_finish)
{
  gnome_druid_set_show_finish(gobj(), static_cast<int>(show_finish));
}

void Druid::set_show_help(bool show_help)
{
  gnome_druid_set_show_help(gobj(), static_cast<int>(show_help));
}

void Druid::prepend_page(const DruidPage & page)
{
  gnome_druid_prepend_page(gobj(), const_cast<GnomeDruidPage*>(page.gobj()));
}

void Druid::insert_page(const DruidPage & back_page, const DruidPage & page)
{
  gnome_druid_insert_page(gobj(), const_cast<GnomeDruidPage*>(back_page.gobj()), const_cast<GnomeDruidPage*>(page.gobj()));
}

void Druid::append_page(const DruidPage & page)
{
  gnome_druid_append_page(gobj(), const_cast<GnomeDruidPage*>(page.gobj()));
}

void Druid::set_page(const DruidPage & page)
{
  gnome_druid_set_page(gobj(), const_cast<GnomeDruidPage*>(page.gobj()));
}


Glib::SignalProxy0<void> Druid::signal_cancel()
{
  return Glib::SignalProxy0<void>(this, &Druid_signal_cancel_info);
}

Glib::SignalProxy0<void> Druid::signal_help()
{
  return Glib::SignalProxy0<void>(this, &Druid_signal_help_info);
}


Glib::PropertyProxy<bool> Druid::property_show_finish()
{
  return Glib::PropertyProxy<bool>(this, "show_finish");
}

Glib::PropertyProxy<bool> Druid::property_show_help()
{
  return Glib::PropertyProxy<bool>(this, "show_help");
}


void Gnome::UI::Druid::on_cancel()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cancel)
    (*base->cancel)(gobj());
}

void Gnome::UI::Druid::on_help()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->help)
    (*base->help)(gobj());
}


} // namespace UI

} // namespace Gnome

