
#include <libgnomeuimm/druid-page.h>
#include <libgnomeuimm/private/druid-page_p.h>

/* $Id: druid-page.ccg,v 1.6 2002/04/27 20:24:50 murrayc Exp $ */


/* druid-page.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace UI
{

void DruidPage::set_bg_color(const Gdk::Color& color)
{}

void DruidPage::set_title(const Glib::ustring& title)
{}

void DruidPage::set_title_color(const Gdk::Color& color)
{}

//void DruidPage::set_logo(const Gdk_Imlib::Image& logo_image)
//{}

void DruidPage::set_logo_bg_color(const Gdk::Color& color)
{}

} /* namespace UI */
} /* namespace Gnome */


namespace
{


gboolean DruidPage_signal_next_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<bool,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean DruidPage_signal_next_notify_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo DruidPage_signal_next_info =
{
  "next",
  (GCallback) &DruidPage_signal_next_callback,
  (GCallback) &DruidPage_signal_next_notify_callback
};


void DruidPage_signal_prepare_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo DruidPage_signal_prepare_info =
{
  "prepare",
  (GCallback) &DruidPage_signal_prepare_callback,
  (GCallback) &DruidPage_signal_prepare_callback
};


gboolean DruidPage_signal_back_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<bool,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean DruidPage_signal_back_notify_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo DruidPage_signal_back_info =
{
  "back",
  (GCallback) &DruidPage_signal_back_callback,
  (GCallback) &DruidPage_signal_back_notify_callback
};


void DruidPage_signal_finish_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo DruidPage_signal_finish_info =
{
  "finish",
  (GCallback) &DruidPage_signal_finish_callback,
  (GCallback) &DruidPage_signal_finish_callback
};


gboolean DruidPage_signal_cancel_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<bool,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean DruidPage_signal_cancel_notify_callback(GnomeDruidPage*, GtkWidget* p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,Gtk::Widget&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (*(Glib::wrap(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo DruidPage_signal_cancel_info =
{
  "cancel",
  (GCallback) &DruidPage_signal_cancel_callback,
  (GCallback) &DruidPage_signal_cancel_notify_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::DruidPage* wrap(GnomeDruidPage* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::DruidPage *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType DruidPage_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_druid_page_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void DruidPage_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->next = &next_callback;
  klass->prepare = &prepare_callback;
  klass->back = &back_callback;
  klass->finish = &finish_callback;
  klass->cancel = &cancel_callback;
}


gboolean DruidPage_Class::next_callback(GnomeDruidPage* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_next(*(Glib::wrap(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->next)
      (*base->next)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

void DruidPage_Class::prepare_callback(GnomeDruidPage* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_prepare(*(Glib::wrap(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->prepare)
      (*base->prepare)(self, p0);
  }
}

gboolean DruidPage_Class::back_callback(GnomeDruidPage* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_back(*(Glib::wrap(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->back)
      (*base->back)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

void DruidPage_Class::finish_callback(GnomeDruidPage* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_finish(*(Glib::wrap(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->finish)
      (*base->finish)(self, p0);
  }
}

gboolean DruidPage_Class::cancel_callback(GnomeDruidPage* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_cancel(*(Glib::wrap(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cancel)
      (*base->cancel)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* DruidPage_Class::wrap_new(GObject* o)
{
  return manage(new DruidPage((GnomeDruidPage*)(o)));
}


/* The implementation: */

DruidPage::DruidPage(GnomeDruidPage* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

DruidPage::~DruidPage()
{
  destroy_();
}

DruidPage::CppClassType DruidPage::druidpage_class_; //Initialize static member.

GType DruidPage::get_type()
{
  return druidpage_class_.get_type();
}

GType DruidPage::get_base_type()
{
  return gnome_druid_page_get_type();
}

DruidPage::DruidPage()
: Gtk::Bin((GtkBin*)(g_object_new(get_type(), (char*)0)))
{}

bool DruidPage::next()
{
  return gnome_druid_page_next(gobj());
}

void DruidPage::prepare()
{
  gnome_druid_page_prepare(gobj());
}

bool DruidPage::back()
{
  return gnome_druid_page_back(gobj());
}

void DruidPage::finish()
{
  gnome_druid_page_finish(gobj());
}

bool DruidPage::cancel()
{
  return gnome_druid_page_cancel(gobj());
}


Glib::SignalProxy1<bool,Gtk::Widget&> DruidPage::signal_next()
{
  return Glib::SignalProxy1<bool,Gtk::Widget&>(this, &DruidPage_signal_next_info);
}

Glib::SignalProxy1<void,Gtk::Widget&> DruidPage::signal_prepare()
{
  return Glib::SignalProxy1<void,Gtk::Widget&>(this, &DruidPage_signal_prepare_info);
}

Glib::SignalProxy1<bool,Gtk::Widget&> DruidPage::signal_back()
{
  return Glib::SignalProxy1<bool,Gtk::Widget&>(this, &DruidPage_signal_back_info);
}

Glib::SignalProxy1<void,Gtk::Widget&> DruidPage::signal_finish()
{
  return Glib::SignalProxy1<void,Gtk::Widget&>(this, &DruidPage_signal_finish_info);
}

Glib::SignalProxy1<bool,Gtk::Widget&> DruidPage::signal_cancel()
{
  return Glib::SignalProxy1<bool,Gtk::Widget&>(this, &DruidPage_signal_cancel_info);
}


bool Gnome::UI::DruidPage::on_next(Gtk::Widget& druid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->next)
    return (*base->next)(gobj(),(druid).gobj());

  typedef bool RType;
  return RType();
}

void Gnome::UI::DruidPage::on_prepare(Gtk::Widget& druid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->prepare)
    (*base->prepare)(gobj(),(druid).gobj());
}

bool Gnome::UI::DruidPage::on_back(Gtk::Widget& druid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->back)
    return (*base->back)(gobj(),(druid).gobj());

  typedef bool RType;
  return RType();
}

void Gnome::UI::DruidPage::on_finish(Gtk::Widget& druid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->finish)
    (*base->finish)(gobj(),(druid).gobj());
}

bool Gnome::UI::DruidPage::on_cancel(Gtk::Widget& druid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cancel)
    return (*base->cancel)(gobj(),(druid).gobj());

  typedef bool RType;
  return RType();
}


} // namespace UI

} // namespace Gnome

