/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.glib.EventType;
import org.gnu.gtk.event.GtkEvent;

/**
 * An event represeting action by a {@link org.gnu.gnome.Client} widget.
 */
public class ClientEvent extends GtkEvent {
	/**
	 * Type of a ClientEvent
	 */
	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}
		public static final Type SAVE_YOURSELF = new Type(1, "SAVE_YOURSELF");
		public static final Type DIE = new Type(2, "DIE");
		public static final Type SAVE_COMPLETE = new Type(3, "SAVE_COMPLETE");
		public static final Type SHUTDOWN_CANCELLED = new Type(4, "SHUTDOWN_CANCELLED");
		public static final Type CONNECT = new Type(5, "CONNECT");
		public static final Type DISCONNECT = new Type(6, "DISCONNECT");
	}

	/**
	 * Creates a new ClientEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public ClientEvent(Object source, ClientEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ClientEvent.Type aType) {
		return (type.getID() == aType.getID());
	}

}
