/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:57 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gnome_client_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_config_prefix
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1config_1prefix (
        JNIEnv *env, jclass cls, jint client) 
    {
        gchar *result_g = (gchar*)gnome_client_get_config_prefix ((GnomeClient*)client);
       	return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_global_config_prefix
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL 
    Java_org_gnu_gnome_Client_gnome_1client_1get_1global_1config_1prefix (JNIEnv *env, jclass cls, 
        jint client) 
    {
        gchar *result_g = (gchar*)gnome_client_get_global_config_prefix ((GnomeClient*)client);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_global_config_prefix
     * Signature: (Ijava.lang.String)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1global_1config_1prefix (
        JNIEnv *env, jclass cls, jint client, jstring prefix) 
    {
        const gchar* prefix_g = (*env)->GetStringUTFChars(env, prefix, 0);
        gnome_client_set_global_config_prefix ((GnomeClient*)client, prefix_g);
        if (prefix) 
        	(*env)->ReleaseStringUTFChars(env, prefix, prefix_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_flags
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1flags (JNIEnv *env, jclass 
        cls, jint client) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        {
            jint result_j = (jint) (gnome_client_get_flags (client_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_restart_style
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1restart_1style (JNIEnv 
        *env, jclass cls, jint client, jint style) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        GnomeRestartStyle style_g = (GnomeRestartStyle) style;
        {
            gnome_client_set_restart_style (client_g, style_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_priority
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1priority (JNIEnv *env, 
        jclass cls, jint client, jint priority) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 priority_g = (gint32) priority;
        {
            gnome_client_set_priority (client_g, priority_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_restart_command
     * Signature: (II[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1restart_1command (JNIEnv 
        *env, jclass cls, jint client, jint argc, jobjectArray args) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 argc_g_int = ((gint32) argc) + 1;
        gchar **args_g_arr = getStringArray(env, args);
        gnome_client_set_restart_command (client_g, argc_g_int, args_g_arr);
        freeStringArray(env, args, args_g_arr);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_discard_command
     * Signature: (II[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1discard_1command (JNIEnv 
        *env, jclass cls, jint client, jint argc, jobjectArray args) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 argc_g_int = ((gint32) argc) + 1;
        gchar **args_g_arr = getStringArray(env, args);
        gnome_client_set_discard_command (client_g, argc_g_int, args_g_arr);
        freeStringArray(env, args, args_g_arr);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_resign_command
     * Signature: (II[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1resign_1command (JNIEnv 
        *env, jclass cls, jint client, jint argc, jobjectArray args) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 argc_g_int = ((gint32) argc) + 1;
        gchar **args_g_arr = getStringArray(env, args);
        gnome_client_set_resign_command (client_g, argc_g_int, args_g_arr);
        freeStringArray(env, args, args_g_arr);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_shutdown_command
     * Signature: (II[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1shutdown_1command (JNIEnv 
        *env, jclass cls, jint client, jint argc, jobjectArray args) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 argc_g = ((gint32) argc) + 1;
		gchar **args_g = getStringArray(env, args);
        gnome_client_set_shutdown_command (client_g, argc_g, args_g);
        freeStringArray(env, args, args_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_current_directory
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1current_1directory (JNIEnv 
        *env, jclass cls, jint client, jstring dir) 
    {
        const gchar* dir_g = (*env)->GetStringUTFChars(env, dir, 0);
        gnome_client_set_current_directory ((GnomeClient*)client, dir_g);
        if (dir) (*env)->ReleaseStringUTFChars(env, dir, dir_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_environment
     * Signature: (Ijava.lang.String;java.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1environment (JNIEnv *env, 
        jclass cls, jint client, jstring name, jstring value) 
    {
        const gchar* name_g = (*env)->GetStringUTFChars(env, name, 0);
        const gchar* value_g = (*env)->GetStringUTFChars(env, value, 0);
        gnome_client_set_environment ((GnomeClient*)client, name_g, value_g);
        if (name) (*env)->ReleaseStringUTFChars(env, name, name_g);
        if (value) (*env)->ReleaseStringUTFChars(env, value, value_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_clone_command
     * Signature: (II[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1clone_1command (JNIEnv 
        *env, jclass cls, jint client, jint argc, jobjectArray args) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 argc_g = ((gint32) argc) + 1;
		gchar **args_g = getStringArray(env, args);
        gnome_client_set_clone_command (client_g, argc_g, args_g);
        freeStringArray(env, args, args_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_process_id
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1process_1id (JNIEnv *env, 
        jclass cls, jint client, jint id) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        gint32 id_g = (gint32) id;
        {
            gnome_client_set_process_id (client_g, id_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_program
     * Signature: (Ijava.lang.String)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1program (JNIEnv *env, 
        jclass cls, jint client, jstring program) 
    {
        const gchar* program_g = (*env)->GetStringUTFChars(env, program, 0);
        gnome_client_set_program ((GnomeClient*)client, program_g);
        if (program) (*env)->ReleaseStringUTFChars(env, program, program_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_user_id
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1user_1id (JNIEnv *env, 
        jclass cls, jint client, jstring id) 
    {
        const gchar* id_g = (*env)->GetStringUTFChars(env, id, 0);
        gnome_client_set_user_id ((GnomeClient*)client, id_g);
        if (id) (*env)->ReleaseStringUTFChars(env, id, id_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_save_any_dialog
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1save_1any_1dialog (JNIEnv *env, 
        jclass cls, jint client, jint dialog) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        GtkDialog *dialog_g = (GtkDialog *)dialog;
        {
            gnome_client_save_any_dialog (client_g, dialog_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_save_error_dialog
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1save_1error_1dialog (JNIEnv 
        *env, jclass cls, jint client, jint dialog) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        GtkDialog *dialog_g = (GtkDialog *)dialog;
        {
            gnome_client_save_error_dialog (client_g, dialog_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_request_phase_2
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1request_1phase_12 (JNIEnv *env, 
        jclass cls, jint client) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        {
            gnome_client_request_phase_2 (client_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_request_save
     * Signature: (IIZIZZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1request_1save (JNIEnv *env, 
        jclass cls, jint client, jint save_style, jboolean shutdown, jint interact_style, jboolean 
        fast, jboolean global) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        GnomeSaveStyle save_style_g = (GnomeSaveStyle) save_style;
        gboolean shutdown_g = (gboolean) shutdown;
        GnomeInteractStyle interact_style_g = (GnomeInteractStyle) interact_style;
        gboolean fast_g = (gboolean) fast;
        gboolean global_g = (gboolean) global;
        {
            gnome_client_request_save (client_g, save_style_g, shutdown_g, interact_style_g, 
                fast_g, global_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_flush
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1flush (JNIEnv *env, jclass cls, 
        jint client) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        {
            gnome_client_flush (client_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_Client_gnome_1client_1new (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gnome_client_new ();
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_connect
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1connect (JNIEnv *env, jclass 
        cls, jint client) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        {
            gnome_client_connect (client_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_disconnect
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1disconnect (JNIEnv *env, jclass 
        cls, jint client) 
    {
        GnomeClient *client_g = (GnomeClient *)client;
        {
            gnome_client_disconnect (client_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_set_id
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_Client_gnome_1client_1set_1id (JNIEnv *env, jclass 
        cls, jint client, jstring id) 
    {
        const gchar* id_g = (*env)->GetStringUTFChars(env, id, 0);
        gnome_client_set_id ((GnomeClient*)client, id_g);
        if (id) (*env)->ReleaseStringUTFChars(env, id, id_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_id
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1id (JNIEnv *env, 
        jclass cls, jint client) 
    {
        gchar *result_g = (gchar*)gnome_client_get_id ((GnomeClient*)client);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_previous_id
     * Signature: (I)java.lang.String
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1previous_1id (JNIEnv 
        *env, jclass cls, jint client) 
    {
        gchar *result_g = (gchar*)gnome_client_get_previous_id ((GnomeClient*)client);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gnome.Client
     * Method:    gnome_client_get_desktop_id
     * Signature: (I)java.lang.String
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_Client_gnome_1client_1get_1desktop_1id (JNIEnv 
        *env, jclass cls, jint client) 
    {
        gchar *result_g = (gchar*)gnome_client_get_desktop_id ((GnomeClient*)client);
        return (*env)->NewStringUTF(env, result_g);
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
