/* testlinkedlist.c generated by valac, the Vala compiler
 * generated from testlinkedlist.vala, do not modify */

/* testlinkedlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Mark Lee <marklee@src.gnome.org> (port to LinkedList)
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



void test_linkedlist_get (void);
void test_linkedlist_set (void);
void test_linkedlist_insert (void);
void test_linkedlist_remove_at (void);
void test_linkedlist_index_of (void);
void test_linkedlist_slice (void);
void test_linkedlist_add (void);
void test_linkedlist_clear (void);
void test_linkedlist_contains (void);
void test_linkedlist_remove (void);
void test_linkedlist_size (void);
void test_linkedlist_iterator (void);
static void _test_linkedlist_get_gcallback (void);
static void _test_linkedlist_set_gcallback (void);
static void _test_linkedlist_insert_gcallback (void);
static void _test_linkedlist_remove_at_gcallback (void);
static void _test_linkedlist_index_of_gcallback (void);
static void _test_linkedlist_slice_gcallback (void);
static void _test_linkedlist_add_gcallback (void);
static void _test_linkedlist_clear_gcallback (void);
static void _test_linkedlist_contains_gcallback (void);
static void _test_linkedlist_remove_gcallback (void);
static void _test_linkedlist_size_gcallback (void);
static void _test_linkedlist_iterator_gcallback (void);
void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



void test_linkedlist_get (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp1_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp0_;
		_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0);
		_g_free0 (_tmp0_);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "1");
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "1") == 0);
	_g_free0 (_tmp1_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp2_;
		_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1);
		_g_free0 (_tmp2_);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp3_;
		_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, -1);
		_g_free0 (_tmp3_);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "3");
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "1") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "2") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "3") == 0);
	_g_free0 (_tmp6_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp7_;
		_tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0);
		_g_free0 (_tmp7_);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (linkedlistOfString);
}


void test_linkedlist_set (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp0_;
	char* _tmp1_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_set ((GeeAbstractList*) linkedlistOfString, 0, "0");
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "1") == 0);
	_g_free0 (_tmp0_);
	gee_abstract_list_set ((GeeAbstractList*) linkedlistOfString, 0, "2");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "2") == 0);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_set ((GeeAbstractList*) linkedlistOfString, 1, "0");
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	_g_object_unref0 (linkedlistOfString);
}


void test_linkedlist_insert (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 1, "0");
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 0, "10");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "10") == 0);
	_g_free0 (_tmp0_);
	gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 0, "5");
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "5") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "10") == 0);
	_g_free0 (_tmp2_);
	gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 1, "7");
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "5") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "7") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "10") == 0);
	_g_free0 (_tmp5_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 4, "20");
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, 3, "20");
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "5") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "7") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "10") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 3), "20") == 0);
	_g_free0 (_tmp9_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_insert ((GeeAbstractList*) linkedlistOfString, -1, "0");
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (linkedlistOfString);
}


void test_linkedlist_remove_at (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 0);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 1);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "5");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 5);
	gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 0);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 4);
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "2") == 0);
	_g_free0 (_tmp0_);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "3") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "4") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 3), "5") == 0);
	_g_free0 (_tmp3_);
	gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 3);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 3);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "2") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "3") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "4") == 0);
	_g_free0 (_tmp6_);
	gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 1);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 2);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "2") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "4") == 0);
	_g_free0 (_tmp8_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, 2);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_remove_at ((GeeAbstractList*) linkedlistOfString, -1);
		_g_object_unref0 (linkedlistOfString);
		return;
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (linkedlistOfString);
}


void test_linkedlist_index_of (void) {
	GeeLinkedList* linkedlistOfString;
	GeeLinkedList* linkedlistOfInt;
	GeeLinkedList* linkedlistOfObjects;
	GObject* object1;
	GObject* object2;
	GObject* object3;
	GObject* object4;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "one") == (-1));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "one");
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "one") == 0);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "two") == (-1));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "two");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "three");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "four");
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "one") == 0);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "two") == 1);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "three") == 2);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "four") == 3);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfString, "five") == (-1));
	linkedlistOfInt = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (3));
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfInt, GINT_TO_POINTER (1)) == 0);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfInt, GINT_TO_POINTER (2)) == 1);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfInt, GINT_TO_POINTER (3)) == 2);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfInt, GINT_TO_POINTER (4)) == (-1));
	linkedlistOfObjects = gee_linked_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	object1 = g_object_new (G_TYPE_OBJECT, NULL);
	object2 = g_object_new (G_TYPE_OBJECT, NULL);
	object3 = g_object_new (G_TYPE_OBJECT, NULL);
	object4 = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfObjects, object1);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfObjects, object2);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfObjects, object3);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfObjects, object4);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfObjects, object1) == 0);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfObjects, object2) == 1);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfObjects, object3) == 2);
	g_assert (gee_abstract_list_index_of ((GeeAbstractList*) linkedlistOfObjects, object4) == 3);
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (linkedlistOfInt);
	_g_object_unref0 (linkedlistOfObjects);
	_g_object_unref0 (object1);
	_g_object_unref0 (object2);
	_g_object_unref0 (object3);
	_g_object_unref0 (object4);
}


void test_linkedlist_slice (void) {
	GeeLinkedList* linkedlistOfString;
	GeeList* slicedLinkedListOfString;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	char* _tmp2_;
	GeeList* _tmp3_;
	char* _tmp4_;
	GeeList* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	slicedLinkedListOfString = NULL;
	g_assert (gee_collection_get_size ((GeeCollection*) (_tmp0_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 0, 0))) == 0);
	_g_object_unref0 (_tmp0_);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "one");
	slicedLinkedListOfString = (_tmp1_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 0, 1), _g_object_unref0 (slicedLinkedListOfString), _tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) slicedLinkedListOfString) == 1);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (slicedLinkedListOfString, 0), "one") == 0);
	_g_free0 (_tmp2_);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "two");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "three");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "four");
	slicedLinkedListOfString = (_tmp3_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 1, 2), _g_object_unref0 (slicedLinkedListOfString), _tmp3_);
	g_assert (gee_collection_get_size ((GeeCollection*) slicedLinkedListOfString) == 1);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (slicedLinkedListOfString, 0), "two") == 0);
	_g_free0 (_tmp4_);
	slicedLinkedListOfString = (_tmp5_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 2, 4), _g_object_unref0 (slicedLinkedListOfString), _tmp5_);
	g_assert (gee_collection_get_size ((GeeCollection*) slicedLinkedListOfString) == 2);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (slicedLinkedListOfString, 0), "three") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (slicedLinkedListOfString, 1), "four") == 0);
	_g_free0 (_tmp7_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp8_;
		_tmp8_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, -1, 0);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (linkedlistOfString);
		_g_object_unref0 (slicedLinkedListOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp9_;
		_tmp9_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 0, -1);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (linkedlistOfString);
		_g_object_unref0 (slicedLinkedListOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp10_;
		_tmp10_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 1, 0);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (linkedlistOfString);
		_g_object_unref0 (slicedLinkedListOfString);
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp11_;
		_tmp11_ = gee_abstract_list_slice ((GeeAbstractList*) linkedlistOfString, 1, 5);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (linkedlistOfString);
		_g_object_unref0 (slicedLinkedListOfString);
		return;
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (slicedLinkedListOfString);
}


void test_linkedlist_add (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GeeLinkedList* linkedlistOfInt;
	GeeLinkedList* linkedlistOfGLibObject;
	GObject* fooObject;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "42"));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "43");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "44");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "45");
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "42") == 0);
	_g_free0 (_tmp0_);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "43") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "44") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 3), "45") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 4);
	linkedlistOfInt = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (42));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfInt) == 1);
	linkedlistOfGLibObject = gee_linked_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	fooObject = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfGLibObject, fooObject);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfGLibObject, fooObject));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfGLibObject) == 1);
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (linkedlistOfInt);
	_g_object_unref0 (linkedlistOfGLibObject);
	_g_object_unref0 (fooObject);
}


void test_linkedlist_clear (void) {
	GeeLinkedList* linkedlistOfString;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "3");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 0);
	_g_object_unref0 (linkedlistOfString);
}


void test_linkedlist_contains (void) {
	GeeLinkedList* linkedlistOfString;
	GeeLinkedList* linkedlistOfInt;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "1"));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "10");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "20");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "30");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "20"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "30"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "30"));
	linkedlistOfInt = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (10));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (20));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (30));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (20)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfInt);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (30)));
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (linkedlistOfInt);
}


void test_linkedlist_remove (void) {
	GeeLinkedList* linkedlistOfString;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	GeeLinkedList* linkedlistOfInt;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "42"));
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) linkedlistOfString, "42"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlistOfString);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "43");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "44");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "45");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 5);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 4);
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "43") == 0);
	_g_free0 (_tmp0_);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "44") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "45") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 3), "46") == 0);
	_g_free0 (_tmp3_);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 3);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "43") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "44") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 2), "45") == 0);
	_g_free0 (_tmp6_);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfString, "44");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfString) == 2);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 0), "43") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_abstract_list_get ((GeeAbstractList*) linkedlistOfString, 1), "45") == 0);
	_g_free0 (_tmp8_);
	linkedlistOfInt = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (42));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (43));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (44));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (45));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfInt) == 5);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (42));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfInt) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 1)) == 44);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 2)) == 45);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 3)) == 46);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfInt) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 1)) == 44);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 2)) == 45);
	gee_abstract_collection_remove ((GeeAbstractCollection*) linkedlistOfInt, GINT_TO_POINTER (44));
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlistOfInt) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) linkedlistOfInt, 1)) == 45);
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (linkedlistOfInt);
}


void test_linkedlist_size (void) {
	GeeLinkedList* linkedlist;
	linkedlist = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlist) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlist, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlist) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlist, "2");
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlist) == 2);
	gee_abstract_collection_clear ((GeeAbstractCollection*) linkedlist);
	g_assert (gee_collection_get_size ((GeeCollection*) linkedlist) == 0);
	_g_object_unref0 (linkedlist);
}


void test_linkedlist_iterator (void) {
	GeeLinkedList* linkedlistOfString;
	GeeIterator* iterator;
	GeeIterator* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	linkedlistOfString = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) linkedlistOfString);
	g_assert (!gee_iterator_next (iterator));
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "43");
	gee_abstract_collection_add ((GeeAbstractCollection*) linkedlistOfString, "44");
	iterator = (_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) linkedlistOfString), _g_object_unref0 (iterator), _tmp0_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_iterator_get (iterator), "42") == 0);
	_g_free0 (_tmp1_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get (iterator), "43") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get (iterator), "44") == 0);
	_g_free0 (_tmp3_);
	g_assert (!gee_iterator_next (iterator));
	_g_object_unref0 (linkedlistOfString);
	_g_object_unref0 (iterator);
}


static void _test_linkedlist_get_gcallback (void) {
	test_linkedlist_get ();
}


static void _test_linkedlist_set_gcallback (void) {
	test_linkedlist_set ();
}


static void _test_linkedlist_insert_gcallback (void) {
	test_linkedlist_insert ();
}


static void _test_linkedlist_remove_at_gcallback (void) {
	test_linkedlist_remove_at ();
}


static void _test_linkedlist_index_of_gcallback (void) {
	test_linkedlist_index_of ();
}


static void _test_linkedlist_slice_gcallback (void) {
	test_linkedlist_slice ();
}


static void _test_linkedlist_add_gcallback (void) {
	test_linkedlist_add ();
}


static void _test_linkedlist_clear_gcallback (void) {
	test_linkedlist_clear ();
}


static void _test_linkedlist_contains_gcallback (void) {
	test_linkedlist_contains ();
}


static void _test_linkedlist_remove_gcallback (void) {
	test_linkedlist_remove ();
}


static void _test_linkedlist_size_gcallback (void) {
	test_linkedlist_size ();
}


static void _test_linkedlist_iterator_gcallback (void) {
	test_linkedlist_iterator ();
}


void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/LinkedList/List/get", _test_linkedlist_get_gcallback);
	g_test_add_func ("/LinkedList/List/set", _test_linkedlist_set_gcallback);
	g_test_add_func ("/LinkedList/List/insert", _test_linkedlist_insert_gcallback);
	g_test_add_func ("/LinkedList/List/remove_at", _test_linkedlist_remove_at_gcallback);
	g_test_add_func ("/LinkedList/List/index_of", _test_linkedlist_index_of_gcallback);
	g_test_add_func ("/LinkedList/List/slice", _test_linkedlist_slice_gcallback);
	g_test_add_func ("/LinkedList/Collection/add", _test_linkedlist_add_gcallback);
	g_test_add_func ("/LinkedList/Collection/clear", _test_linkedlist_clear_gcallback);
	g_test_add_func ("/LinkedList/Collection/contains", _test_linkedlist_contains_gcallback);
	g_test_add_func ("/LinkedList/Collection/remove", _test_linkedlist_remove_gcallback);
	g_test_add_func ("/LinkedList/Collection/size", _test_linkedlist_size_gcallback);
	g_test_add_func ("/LinkedList/Iterable/iterator", _test_linkedlist_iterator_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




