/* testhashset.c generated by valac, the Vala compiler
 * generated from testhashset.vala, do not modify */

/* testhashset.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



void test_hashset_add (void);
void test_hashset_clear (void);
void test_hashset_contains (void);
void test_hashset_remove (void);
void test_hashset_size (void);
void test_hashset_iterator (void);
void test_hashset_empty (void);
void test_hashset_add_all (void);
void test_hashset_contains_all (void);
void test_hashset_remove_all (void);
void test_hashset_retain_all (void);
static void _test_hashset_add_gcallback (void);
static void _test_hashset_clear_gcallback (void);
static void _test_hashset_contains_gcallback (void);
static void _test_hashset_remove_gcallback (void);
static void _test_hashset_size_gcallback (void);
static void _test_hashset_empty_gcallback (void);
static void _test_hashset_add_all_gcallback (void);
static void _test_hashset_contains_all_gcallback (void);
static void _test_hashset_remove_all_gcallback (void);
static void _test_hashset_retain_all_gcallback (void);
static void _test_hashset_iterator_gcallback (void);
void _main (char** args, int args_length1);



void test_hashset_add (void) {
	GeeHashSet* hashset;
	GeeHashSet* hashsetInt;
	GeeHashSet* hashsetObject;
	GObject* fooObject;
	GObject* fooObject2;
	hashset = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "42");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, "42"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "43");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, "42"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, "43"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "43");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, "42"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, "43"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 2);
	hashsetInt = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43)));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43)));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 2);
	hashsetObject = gee_hash_set_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	fooObject = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetObject, fooObject);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetObject, fooObject));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetObject) == 1);
	fooObject2 = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetObject, fooObject2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetObject, fooObject));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetObject, fooObject2));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetObject) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetObject) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetObject, fooObject2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetObject, fooObject));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetObject, fooObject2));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetObject) == 2);
	_g_object_unref0 (hashset);
	_g_object_unref0 (hashsetInt);
	_g_object_unref0 (hashsetObject);
	_g_object_unref0 (fooObject);
	_g_object_unref0 (fooObject2);
}


void test_hashset_clear (void) {
	GeeHashSet* hashset;
	hashset = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "3");
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	_g_object_unref0 (hashset);
}


void test_hashset_contains (void) {
	GeeHashSet* hashsetString;
	GeeHashSet* hashsetInt;
	hashsetString = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "1"));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "10");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "20");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "30");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "20"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "30"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashsetString);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "30"));
	hashsetInt = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (10));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (20));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (30));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (20)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashsetInt);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (30)));
	_g_object_unref0 (hashsetString);
	_g_object_unref0 (hashsetInt);
}


void test_hashset_remove (void) {
	GeeHashSet* hashsetString;
	GeeHashSet* hashsetInt;
	hashsetString = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "43");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "44");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "45");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetString) == 5);
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetString) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "44"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "45"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "46"));
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetString) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "44"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "45"));
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetString, "44");
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetString) == 2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetString, "45"));
	hashsetInt = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (44));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (45));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 5);
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (42));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (44)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (45)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (46)));
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (44)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (45)));
	gee_abstract_collection_remove ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (44));
	g_assert (gee_collection_get_size ((GeeCollection*) hashsetInt) == 2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashsetInt, GINT_TO_POINTER (45)));
	_g_object_unref0 (hashsetString);
	_g_object_unref0 (hashsetInt);
}


void test_hashset_size (void) {
	GeeHashSet* hashset;
	hashset = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "2");
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 2);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset) == 0);
	_g_object_unref0 (hashset);
}


void test_hashset_iterator (void) {
	GeeHashSet* hashset;
	GeeIterator* iterator;
	GeeIterator* _tmp0_;
	char* firstString;
	char* secondString;
	hashset = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) hashset);
	g_assert (!gee_iterator_next (iterator));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "43");
	iterator = (_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) hashset), _g_object_unref0 (iterator), _tmp0_);
	g_assert (gee_iterator_next (iterator));
	firstString = (char*) gee_iterator_get (iterator);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, firstString));
	g_assert (gee_iterator_next (iterator));
	secondString = (char*) gee_iterator_get (iterator);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset, secondString));
	g_assert (!g_str_equal (firstString, secondString));
	g_assert (!gee_iterator_next (iterator));
	_g_object_unref0 (hashset);
	_g_object_unref0 (iterator);
	_g_free0 (firstString);
	_g_free0 (secondString);
}


void test_hashset_empty (void) {
	GeeHashSet* hashset;
	hashset = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "1");
	g_assert (!gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset, "2");
	g_assert (!gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset));
	_g_object_unref0 (hashset);
}


void test_hashset_add_all (void) {
	GeeHashSet* hashset1;
	GeeHashSet* hashset2;
	hashset1 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	hashset2 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "1"));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "1");
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "1"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "1"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "0");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "5");
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 6);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "0"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "3"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "4"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "5"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "3"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "4"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "5"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "0");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "5");
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 6);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "0"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "3"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "4"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "5"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "3"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "4"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, "5"));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "0");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	{
		gint i;
		i = 3;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < 103)) {
					break;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, _tmp1_ = g_strdup_printf ("%d", i));
				_g_free0 (_tmp1_);
			}
		}
	}
	gee_abstract_collection_add_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 103);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "0"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "3"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "4"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "5"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "99"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "100"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "101"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, "102"));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 100);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	_g_object_unref0 (hashset1);
	_g_object_unref0 (hashset2);
}


void test_hashset_contains_all (void) {
	GeeHashSet* hashset1;
	GeeHashSet* hashset2;
	hashset1 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	hashset2 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "1");
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "2");
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "5");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "6");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "6");
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "5");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "6");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "6");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "7");
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	_g_object_unref0 (hashset1);
	_g_object_unref0 (hashset2);
}


void test_hashset_remove_all (void) {
	GeeHashSet* hashset1;
	GeeHashSet* hashset2;
	hashset1 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	hashset2 = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "4");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "5");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "6");
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, "3");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, "3");
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset1));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	_g_object_unref0 (hashset1);
	_g_object_unref0 (hashset2);
}


void test_hashset_retain_all (void) {
	GeeHashSet* hashset1;
	GeeHashSet* hashset2;
	hashset1 = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL);
	hashset2 = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset2));
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) hashset2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (3));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 0);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (6));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (6));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (3));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (7));
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 5);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 4);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) hashset1, (GeeCollection*) hashset2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset1) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) hashset2) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset1, GINT_TO_POINTER (2)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) hashset2, GINT_TO_POINTER (3)));
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) hashset2);
	_g_object_unref0 (hashset1);
	_g_object_unref0 (hashset2);
}


static void _test_hashset_add_gcallback (void) {
	test_hashset_add ();
}


static void _test_hashset_clear_gcallback (void) {
	test_hashset_clear ();
}


static void _test_hashset_contains_gcallback (void) {
	test_hashset_contains ();
}


static void _test_hashset_remove_gcallback (void) {
	test_hashset_remove ();
}


static void _test_hashset_size_gcallback (void) {
	test_hashset_size ();
}


static void _test_hashset_empty_gcallback (void) {
	test_hashset_empty ();
}


static void _test_hashset_add_all_gcallback (void) {
	test_hashset_add_all ();
}


static void _test_hashset_contains_all_gcallback (void) {
	test_hashset_contains_all ();
}


static void _test_hashset_remove_all_gcallback (void) {
	test_hashset_remove_all ();
}


static void _test_hashset_retain_all_gcallback (void) {
	test_hashset_retain_all ();
}


static void _test_hashset_iterator_gcallback (void) {
	test_hashset_iterator ();
}


void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/HashSet/Collection/add", _test_hashset_add_gcallback);
	g_test_add_func ("/HashSet/Collection/clear", _test_hashset_clear_gcallback);
	g_test_add_func ("/HashSet/Collection/contains", _test_hashset_contains_gcallback);
	g_test_add_func ("/HashSet/Collection/remove", _test_hashset_remove_gcallback);
	g_test_add_func ("/HashSet/Collection/size", _test_hashset_size_gcallback);
	g_test_add_func ("/HashSet/Collection/empty", _test_hashset_empty_gcallback);
	g_test_add_func ("/HashSet/Collection/add_all", _test_hashset_add_all_gcallback);
	g_test_add_func ("/HashSet/Collection/contains_all", _test_hashset_contains_all_gcallback);
	g_test_add_func ("/HashSet/Collection/remove_all", _test_hashset_remove_all_gcallback);
	g_test_add_func ("/HashSet/Collection/retain_all", _test_hashset_retain_all_gcallback);
	g_test_add_func ("/HashSet/Iterable/iterator", _test_hashset_iterator_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}




