/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContactAddress.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1new
(JNIEnv *env, jclass cls)
{
    return getStructHandle(env, g_new0(EContactAddress, 1), NULL, (JGFreeFunc)e_contact_address_free);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_address_format
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1address_1format
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->address_format);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_po
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1po
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->po);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_ext
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1ext
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->ext);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_street
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1street
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->street);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_locality
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1locality
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->locality);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_region
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1region
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->region);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_code
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1code
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->code);
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_get_country
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1get_1country
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_address->country);
}


/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_address_format
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1address_1format
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->address_format = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_po
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1po
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->po = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_ext
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1ext
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->ext = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_street
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1street
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->street = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_locality
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1locality
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->locality = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_region
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1region
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->region = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_code
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1code
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->code = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactAddress
 * Method:    e_contact_address_set_country
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactAddress_e_1contact_1address_1set_1country
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactAddress *contact_address = (EContactAddress*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_address->country = value_g;
}

#ifdef __cplusplus
}

#endif
