/*
 *  Copyright (C) 1999-2001 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include "dialogs.h"

/* Callback */
static void
close_dialog_about_cb (GtkWidget *widget, GtkWidget **about)
{
    *about = NULL;
}

/* Display a nice dialog box */
void
dialog_about (void)
{
    static GtkWidget *about = NULL;
    const gchar *authors[] = {
	"Bruno Pires Marinho <bapm@rnl.ist.utl.pt>",
	NULL
    };

    if (about != NULL) {
	gdk_window_raise (GTK_WIDGET (GNOME_DIALOG (about))->window);
	return;
    }

    about = gnome_about_new (_ ("GNOME Transfer Manager Applet"), VERSION,
			     "Copyright (C) 1999-2001 Bruno Pires Marinho",
			     authors,
			     _ ("The GNOME transfer manager applet.\n"
				"http://gtm.sourceforge.net/"),
			     NULL);
    gtk_signal_connect (GTK_OBJECT (about), "destroy", 
			GTK_SIGNAL_FUNC (close_dialog_about_cb), 
			(gpointer) &about);
    gtk_widget_show (about);
}
