/*
 *  Copyright (C) 1999, 2000 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include "gtm.h"
#include "file-data.h"
#include "dialogs.h"

/* Callback */
static void
close_dialog_about_cb (GtkWidget *widget, GtkWidget **about)
{
    *about = NULL;
}

/* Display a nice dialog box */
void
dialog_about (void)
{
    static GtkWidget *about = NULL;
    const gchar *authors[] = {
	"Bruno Pires Marinho <bapm@netcabo.pt>, Main author",
	"Gianluca Montecchi <gianluca@pluto.linux.it>",
	"Ross Arnold <ronz@users.sourceforge.net>",
        "Matthew Tuck  <matty@chariot.net.au>",
	NULL
    };

    if (about != NULL) {
	gdk_window_raise (GTK_WIDGET (GNOME_DIALOG (about))->window);
	return;
    }

    about = gnome_about_new (_ ("GNOME Transfer Manager"), VERSION,
			     "Copyright (C) 1999, 2000 Bruno Pires Marinho",
			     authors,
			     _ ("The GNOME transfer manager.\n"
				"http://gtm.sourceforge.net/"),
			     NULL);
    gtk_signal_connect (GTK_OBJECT (about), "destroy", 
			GTK_SIGNAL_FUNC (close_dialog_about_cb), 
			(gpointer) &about);
    gnome_dialog_set_parent (GNOME_DIALOG (about), GTK_WINDOW (gtm_app));
    gtk_widget_show (about);
}
