/*
 *  Copyright (C) 1999, 2000 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GTM_H
#define _GTM_H

typedef struct 
{
    gboolean use_proxy;
    gchar *proxy_user;
    gchar *proxy_pass;
    gchar *proxy_http;
    gchar *proxy_ftp;
    guint toolbar_style;
    gchar *def_download_dir;
    guint file_list_refresh;
    guint num_retries;
    gchar *interface;
    gint num_of_auto_download;
    guint chk_interf_time;
    gboolean use_passive_ftp;
    gboolean addnew_changes_def_dl_dir;
    gboolean show_list_stat;
    gboolean show_page_stat;
    gboolean confirm_remove_incomplete;
    gboolean confirm_remove_completed;
    gboolean confirm_restart;
    gboolean manual_stop_disables_auto_dl;
    gboolean show_dl_info_page;
    gboolean confirm_dnd_url;
    gboolean use_sound;
    gboolean use_beep;
    gboolean stop_dl_on_link_loss;
} Preferences;

/* The application used in save_state */
extern GtkWidget *gtm_app;

/* The program preferences */
extern Preferences gtm_pref;

/* The program download list */
extern GtkWidget *dl_file_list;

/* Number of active automatic download */
extern gint num_of_download;

/* ID used on the next file data created */
extern guint next_file_id;

/* Report an event by playing a sound or/and beeping */
void report_event (gchar *which);

#endif /* _GTM_H */
