/*
 *  Copyright (C) 1999, 2000 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _FILE_DATA_H
#define _FILE_DATA_H

typedef enum
{
    DL_NOT_STARTED,       /* We have not started the download of the file */
    DL_NOT_RUNNING,       /* Wget is not running */
    DL_NOT_CONNECTED,     /* Wget is trying to connect with remote host */
    DL_CONNECTED,         /* Wget is connected with remote host */
    DL_RETRIEVING,        /* Wget is retrieving the file */
    DL_COMPLETED          /* The downloaded is completed */
} DlState;

typedef struct 
{
    pid_t wget_pid;             /* Pid of the process running wget */
    gint log_fd;                /* File descriptor of the wget log file */
    gint log_tag;               /* Tag to the function monitoring the log */
    gchar *url;                 /* URL to the file to download */
    gchar *dir;                 /* Directory where the file will be saved */
    gchar *filename;            /* Name of the file being downloaded */
    gchar *local_filename;      /* Used to get the status of the download */
    gboolean disable_proxy;     /* Used to disable the proxy use */
    gboolean disable_auto_dl;   /* Used to disable the auto download */
    gchar *line;                /* Used to process the wget output */
    gint line_pos;              /* Used to process the wget output */
    guint32 total_size;         /* Total file size in bytes */
    guint32 total_time;         /* Total time spent in seconds */
    time_t session_start_time;  /* Time at start of this download session */
    guint32 session_start_size; /* Size at start of this download session */
    guint32 session_elapsed;    /* Time spent in seconds on this session */
    guint32 cur_size;           /* Current downloaded file size */
    DlState state;              /* State of the download */
    GtkWidget *file_list;       /* File list where this file is inserted */
    guint id;                   /* File data id */
} FileData;

#define file_data_run(file_data) ((file_data->log_tag != -1) ? TRUE : FALSE)

gchar *file_data_state_name (FileData *file_data);

void file_data_free (FileData *file_data);

void file_data_set_state (FileData *file_data, DlState state);

void file_data_set_total_size (FileData *file_data, guint32 total_size);

void file_data_set_url (FileData *file_data, gchar *url);

int file_data_url_valid (const gchar *url);

void file_data_set_disable_proxy (FileData *file_data,
                                  gboolean disable_proxy);

void file_data_set_disable_auto_dl (FileData *file_data,
                                    gboolean disable_auto_dl);

void file_data_update_statistics (FileData *file_data);

void file_data_start_download (FileData *file_data);

void file_data_stop_download (FileData *file_data);

void file_data_restart_download (FileData *file_data);

FileData * file_data_create (gchar *url, gchar *dir, gboolean disable_proxy,
                             gboolean disable_auto_dl);

#endif /* _FILE_DATA_H */
