/* The CSS Theme Engine for Gtk+.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "gce-functions.h"

static char *
url (GSList const *args)
{
	char const *uri;

	g_return_val_if_fail (args, NULL);

	uri = (char const *) args->data;
	return gtk_rc_find_pixmap_in_path (gtk_settings_get_default (), NULL, uri);
}

static ccd_function_t const _functions[] = 
{
	{ "url", url },
	{ NULL }
};

ccd_function_t const *
gce_functions_get_vtable (void)
{
	return _functions;
}

