/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "ccd.h"

/**
 * ccd_init:
 * @node_class: 	dispatch table as described at #ccd_node_class_t.
 * @functions:		table of functions that can be used in CSS.
 * @n_functions:	size of the function table.
 * 
 * Initialize the CCD library before making any calls to it.
 **/
void
ccd_init (ccd_node_class_t const	*node_class,
	  ccd_function_t const		*vtable)
{
	g_assert (node_class);

	ccd_node_set_class (node_class);
	ccd_function_set_vtable (vtable);
}

/**
 * ccd_shutdown:
 *
 * Shut down the CCD library.
 **/
void
ccd_shutdown (void)
{
	ccd_node_reset_class ();
}

