/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_BLOCK_H
#define CCD_BLOCK_H

#include <glib.h>
#include <cairo.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-color.h>
#include <ccd/ccd-background.h>
#include <ccd/ccd-border.h>
#include <ccd/ccd-property.h>

G_BEGIN_DECLS

typedef struct {
	/*< private >*/
	ccd_background_t	background;
	ccd_border_t		border;
	ccd_color_t		color;
	ccd_property_spec_t	color_spec;
} ccd_block_t;

ccd_block_t *	ccd_block_new	(void);
void		ccd_block_free	(ccd_block_t *self);

void ccd_block_dump (ccd_block_t const *self);

G_END_DECLS

#endif /* CCD_BLOCK_H */

