
/*  A Bison parser, made from parser.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUMBER	258
#define	STRING	259
#define	FUNCALL	260
#define	CONSTANT	261
#define	CELLREF	262
#define	GTE	263
#define	LTE	264
#define	NE	265
#define	SHEETREF	266
#define	BOOKREF	267
#define	SEPARATOR	268
#define	NEG	269
#define	PLUS	270

#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 */
#include <config.h>
#include <ctype.h>
#include <string.h>
#include <locale.h>
#include <gnome.h>
#include "gnumeric.h"
#include "number-match.h"
#include "symbol.h"
#include "expr.h"
#include "sheet.h"
#include "utils.h"
	
/* Allocation with disposal-on-error */ 
static void *alloc_buffer    (int size);
static void  register_symbol (Symbol *sym);
static void  alloc_clean     (void);
static void  alloc_glist     (GList *l); 
static void  forget_glist    (GList *list);
static void  forget_array    (GList *array);
static void  forget_tree     (ExprTree *tree);
static void  alloc_list_free (void); 
static Value*v_new (void);
static void  v_forget (Value *v);
	
#define ERROR -1
 
/* Types of items we know how to dispose on error */ 
typedef enum {
	ALLOC_SYMBOL,
	ALLOC_VALUE,
	ALLOC_BUFFER,
	ALLOC_LIST
} AllocType;

/* How we keep track of them */ 
typedef struct {
	AllocType type;
	void      *data;
} AllocRec;

/* This keeps a list of  AllocRecs */
static GList *alloc_list;
 
/* Bison/Yacc internals */ 
static int  yylex (void);
static int  yyerror (char *s);

/* The expression being parsed */
static const char *parser_expr;

/* The error returned from the */
static ParseErr parser_error;

/* Location where the parsing is taking place */
static int parser_col, parser_row;

/* The workbook context */
static Workbook *parser_wb;

/* The suggested format to use for this expression */
static const char **parser_desired_format;

/* Locale info.  */
static char parser_decimal_point;
static char parser_separator;
static char parser_array_col_separator;
 
static ExprTree **parser_result;

#define p_new(type) ((type *) alloc_buffer ((unsigned) sizeof (type)))

static ExprTree *
build_unary_op (Operation op, ExprTree *expr)
{
	ExprTree *res = p_new (ExprTree);
	res->ref_count = 1;
	res->oper = op;
	res->u.value = expr;
	return res;
}

static ExprTree *
build_binop (ExprTree *l, Operation op, ExprTree *r)
{
	ExprTree *res = p_new (ExprTree);
	res->ref_count = 1;
	res->u.binary.value_a = l;
	res->oper = op;
	res->u.binary.value_b = r;
	return res;
}

static ExprTree *
build_array_formula (ExprTree *func,
		     ExprTree *expr_num_cols, ExprTree *expr_num_rows,
		     ExprTree *expr_x, ExprTree *expr_y)
{
	int const num_cols = expr_tree_get_const_int (expr_num_cols);
	int const num_rows = expr_tree_get_const_int (expr_num_rows);
	int const x = expr_tree_get_const_int (expr_x);
	int const y = expr_tree_get_const_int (expr_y);
	ExprTree * res = expr_tree_array_formula (x, y, num_rows, num_cols);
	res->u.array.corner.func.expr = func;
	return res;
}

static ExprTree *
build_array (GList *cols)
{
	Value *array;
	GList *row;
	int x, mx, y;

	if (!cols) {
		parser_error = PARSE_ERR_SYNTAX;
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = g_list_next (row);
	}

	array = value_new_array_empty (mx, g_list_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			ExprTree *expr = row->data;
			Value    *v = expr->u.constant;

			g_assert (expr->oper == OPER_CONSTANT);

			value_array_set (array, x, y, v);
			v_forget (v);

			x++;
			row = g_list_next (row);
		}
		if (x < mx || row) {
			parser_error = PARSE_ERR_SYNTAX;
			value_release (array);
			return NULL;
		}
		y++;
		cols = g_list_next (cols);
	}

	return expr_tree_new_constant (array);
}

/* Make byacc happier */
int yyparse(void);


#line 170 "parser.y"
typedef union {
	ExprTree *tree;
	CellRef  *cell;
	GList    *list;
	Sheet    *sheetref;
	Workbook *bookref;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		89
#define	YYFLAG		-32768
#define	YYNTBASE	37

#define YYTRANSLATE(x) ((unsigned)(x) <= 270 ? yytranslate[x] : 44)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    24,     2,     2,     2,    26,    14,     2,    29,
    30,    20,    19,    34,    18,     2,    21,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    33,    36,    15,
    17,    16,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    31,    35,    32,    25,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    27,     2,    28,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    22,    23
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,    17,    19,    21,    23,    25,    27,    31,    35,
    39,    43,    47,    51,    55,    59,    63,    67,    71,    75,
    79,    82,    85,    88,    91,    95,    99,   104,   106,   110,
   117,   119,   123,   124,   126,   128,   130,   134,   138,   139,
   141,   145
};

static const short yyrhs[] = {    38,
     0,    27,    38,    28,    29,     3,    13,     3,    30,    31,
     3,    32,    31,     3,    32,     0,     1,     0,     3,     0,
     4,     0,    39,     0,     6,     0,    38,    19,    38,     0,
    38,    18,    38,     0,    38,    20,    38,     0,    38,    21,
    38,     0,    38,    25,    38,     0,    38,    14,    38,     0,
    38,    17,    38,     0,    38,    15,    38,     0,    38,    16,
    38,     0,    38,     8,    38,     0,    38,    10,    38,     0,
    38,     9,    38,     0,    29,    38,    30,     0,    38,    26,
     0,    18,    38,     0,    19,    38,     0,    19,    38,     0,
    27,    43,    28,     0,    39,    33,    39,     0,     5,    29,
    40,    30,     0,     7,     0,    11,    24,     7,     0,    31,
    12,    32,    11,    24,     7,     0,    38,     0,    38,    13,
    40,     0,     0,     3,     0,     4,     0,    41,     0,    41,
    34,    42,     0,    41,    35,    42,     0,     0,    42,     0,
    42,    36,    43,     0,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   195,   197,   201,   204,   205,   206,   207,   208,   209,   210,
   211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
   222,   223,   224,   226,   230,   235,   249,   255,   259,   264,
   270,   274,   279,   282,   283,   286,   290,   298,   306,   309,
   313,   318
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMBER",
"STRING","FUNCALL","CONSTANT","CELLREF","GTE","LTE","NE","SHEETREF","BOOKREF",
"SEPARATOR","'&'","'<'","'>'","'='","'-'","'+'","'*'","'/'","NEG","PLUS","'!'",
"'^'","'%'","'{'","'}'","'('","')'","'['","']'","':'","','","'\\'","';'","line",
"exp","cellref","arg_list","array_exp","array_row","array_cols", NULL
};
#endif

static const short yyr1[] = {     0,
    37,    37,    37,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    39,    39,    39,
    40,    40,    40,    41,    41,    42,    42,    42,    42,    43,
    43,    43
};

static const short yyr2[] = {     0,
     1,    14,     1,     1,     1,     1,     1,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     2,     2,     2,     2,     3,     3,     4,     1,     3,     6,
     1,     3,     0,     1,     1,     1,     3,     3,     0,     1,
     3,     0
};

static const short yydefact[] = {     0,
     3,     4,     5,     0,     7,    28,     0,     0,     0,    39,
     0,     0,     1,     6,    33,     0,    39,    22,    23,     4,
     5,     0,    36,    40,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
     0,    31,     0,    29,    34,    35,     0,    39,    39,    39,
    25,    20,     0,    17,    19,    18,    13,    15,    16,    14,
     9,     8,    10,    11,    12,    26,    33,    27,     0,    37,
    38,    41,     0,    32,     0,     0,     0,    30,     0,     0,
     0,     0,     0,     0,     0,     2,     0,     0,     0
};

static const short yydefgoto[] = {    87,
    42,    14,    43,    23,    24,    25
};

static const short yypact[] = {    39,
-32768,-32768,-32768,   -17,-32768,-32768,    31,    56,    56,    73,
    56,     7,   151,    -9,    56,    34,     3,     1,     1,   -32,
    13,   116,    17,    20,    36,    97,    33,    56,    56,    56,
    56,    56,    56,    56,    56,    56,    56,    56,    56,-32768,
    -6,   137,    41,-32768,-32768,-32768,    40,     3,     3,     3,
-32768,-32768,    61,    -5,    -5,    -5,   165,    -5,    -5,    -5,
    -3,    -3,     1,     1,     1,-32768,    56,-32768,    70,-32768,
-32768,-32768,    57,-32768,    69,    79,    85,-32768,    59,    62,
    87,    63,    65,    91,    66,-32768,    99,   101,-32768
};

static const short yypgoto[] = {-32768,
     0,    67,    30,-32768,     5,    53
};


#define	YYLAST		191


static const short yytable[] = {    13,
     6,   -34,   -34,   -34,     7,    45,    46,    18,    19,    22,
    26,    15,    35,    36,    37,    38,    37,    38,    27,    39,
    40,    39,    40,    41,    12,    39,    40,    54,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,     1,
    44,     2,     3,     4,     5,     6,   -35,   -35,   -35,     7,
    48,    49,    70,    71,    16,    50,     8,     9,     2,     3,
     4,     5,     6,    51,    53,    10,     7,    11,    69,    12,
    68,    73,    75,     8,     9,    20,    21,     4,     5,     6,
    76,    77,    17,     7,    11,    78,    12,    79,    80,    82,
     8,     9,    81,    85,    83,    84,    74,    86,    88,    17,
    89,    11,    72,    12,    28,    29,    30,    66,     0,     0,
    31,    32,    33,    34,    35,    36,    37,    38,     0,     0,
     0,    39,    40,    28,    29,    30,    52,     0,     0,    31,
    32,    33,    34,    35,    36,    37,    38,     0,     0,     0,
    39,    40,     0,    47,    28,    29,    30,     0,     0,    67,
    31,    32,    33,    34,    35,    36,    37,    38,    28,    29,
    30,    39,    40,     0,    31,    32,    33,    34,    35,    36,
    37,    38,    28,    29,    30,    39,    40,     0,     0,    32,
    33,    34,    35,    36,    37,    38,     0,     0,     0,    39,
    40
};

static const short yycheck[] = {     0,
     7,    34,    35,    36,    11,     3,     4,     8,     9,    10,
    11,    29,    18,    19,    20,    21,    20,    21,    12,    25,
    26,    25,    26,    33,    31,    25,    26,    28,    29,    30,
    31,    32,    33,    34,    35,    36,    37,    38,    39,     1,
     7,     3,     4,     5,     6,     7,    34,    35,    36,    11,
    34,    35,    48,    49,    24,    36,    18,    19,     3,     4,
     5,     6,     7,    28,    32,    27,    11,    29,    29,    31,
    30,    11,     3,    18,    19,     3,     4,     5,     6,     7,
    24,    13,    27,    11,    29,     7,    31,     3,    30,     3,
    18,    19,    31,     3,    32,    31,    67,    32,     0,    27,
     0,    29,    50,    31,     8,     9,    10,    41,    -1,    -1,
    14,    15,    16,    17,    18,    19,    20,    21,    -1,    -1,
    -1,    25,    26,     8,     9,    10,    30,    -1,    -1,    14,
    15,    16,    17,    18,    19,    20,    21,    -1,    -1,    -1,
    25,    26,    -1,    28,     8,     9,    10,    -1,    -1,    13,
    14,    15,    16,    17,    18,    19,    20,    21,     8,     9,
    10,    25,    26,    -1,    14,    15,    16,    17,    18,    19,
    20,    21,     8,     9,    10,    25,    26,    -1,    -1,    15,
    16,    17,    18,    19,    20,    21,    -1,    -1,    -1,    25,
    26
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 195 "parser.y"
{ *parser_result = yyvsp[0].tree; ;
    break;}
case 2:
#line 197 "parser.y"
{
		*parser_result = build_array_formula (yyvsp[-12].tree, yyvsp[-7].tree, yyvsp[-9].tree, yyvsp[-1].tree, yyvsp[-4].tree) ;
	;
    break;}
case 3:
#line 201 "parser.y"
{ parser_error = PARSE_ERR_SYNTAX; ;
    break;}
case 4:
#line 204 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 5:
#line 205 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 6:
#line 206 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 7:
#line 207 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 8:
#line 208 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_ADD,       yyvsp[0].tree); ;
    break;}
case 9:
#line 209 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_SUB,       yyvsp[0].tree); ;
    break;}
case 10:
#line 210 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_MULT,      yyvsp[0].tree); ;
    break;}
case 11:
#line 211 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_DIV,       yyvsp[0].tree); ;
    break;}
case 12:
#line 212 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EXP,       yyvsp[0].tree); ;
    break;}
case 13:
#line 213 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_CONCAT,    yyvsp[0].tree); ;
    break;}
case 14:
#line 214 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EQUAL,     yyvsp[0].tree); ;
    break;}
case 15:
#line 215 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LT,        yyvsp[0].tree); ;
    break;}
case 16:
#line 216 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GT,        yyvsp[0].tree); ;
    break;}
case 17:
#line 217 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GTE,       yyvsp[0].tree); ;
    break;}
case 18:
#line 218 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_NOT_EQUAL, yyvsp[0].tree); ;
    break;}
case 19:
#line 219 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LTE,       yyvsp[0].tree); ;
    break;}
case 20:
#line 220 "parser.y"
{ yyval.tree = yyvsp[-1].tree; ;
    break;}
case 21:
#line 222 "parser.y"
{ yyval.tree = build_unary_op (OPER_PERCENT, yyvsp[-1].tree); ;
    break;}
case 22:
#line 223 "parser.y"
{ yyval.tree = build_unary_op (OPER_NEG, yyvsp[0].tree); ;
    break;}
case 23:
#line 224 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 24:
#line 226 "parser.y"
{
		yyval.tree = yyvsp[0].tree;
	;
    break;}
case 25:
#line 230 "parser.y"
{
		yyval.tree = build_array (yyvsp[-1].list);
		forget_array (yyvsp[-1].list);
	;
    break;}
case 26:
#line 235 "parser.y"
{
		yyval.tree = p_new (ExprTree);
		yyval.tree->ref_count  = 1;
		yyval.tree->oper       = OPER_CONSTANT;
		yyval.tree->u.constant = v_new ();
		yyval.tree->u.constant->type = VALUE_CELLRANGE;
		yyval.tree->u.constant->v.cell_range.cell_a = yyvsp[-2].tree->u.ref;
		yyval.tree->u.constant->v.cell_range.cell_b = yyvsp[0].tree->u.ref;

		forget_tree (yyvsp[-2].tree);
		forget_tree (yyvsp[0].tree);
	;
    break;}
case 27:
#line 249 "parser.y"
{
		yyval.tree = yyvsp[-3].tree;
		yyval.tree->u.function.arg_list = yyvsp[-1].list;
	;
    break;}
case 28:
#line 255 "parser.y"
{
		yyval.tree = yyvsp[0].tree;
	;
    break;}
case 29:
#line 259 "parser.y"
{
	        yyval.tree = yyvsp[0].tree;
		yyval.tree->u.ref.sheet = yyvsp[-2].sheetref;
	;
    break;}
case 30:
#line 264 "parser.y"
{
	        yyval.tree = yyvsp[0].tree;
		yyval.tree->u.ref.sheet = yyvsp[-2].sheetref;
	;
    break;}
case 31:
#line 270 "parser.y"
{
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		alloc_glist (yyval.list);
        ;
    break;}
case 32:
#line 274 "parser.y"
{
		forget_glist (yyvsp[0].list);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
		alloc_glist (yyval.list);
	;
    break;}
case 33:
#line 279 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 34:
#line 282 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 35:
#line 283 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 36:
#line 286 "parser.y"
{
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		alloc_glist (yyval.list);
        ;
    break;}
case 37:
#line 290 "parser.y"
{
		if (parser_array_col_separator == ',') {
			forget_glist (yyvsp[0].list);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			alloc_glist  (yyval.list);
		} else
			parser_error = PARSE_ERR_SYNTAX;
	;
    break;}
case 38:
#line 298 "parser.y"
{
		if (parser_array_col_separator == '\\') {
			forget_glist (yyvsp[0].list);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			alloc_glist  (yyval.list);
		} else
			parser_error = PARSE_ERR_SYNTAX;
	;
    break;}
case 39:
#line 306 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 40:
#line 309 "parser.y"
{
		yyval.list = g_list_prepend (NULL, yyvsp[0].list);
		alloc_glist (yyval.list);
        ;
    break;}
case 41:
#line 313 "parser.y"
{
		forget_glist (yyvsp[0].list);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].list);
		alloc_glist  (yyval.list);
	;
    break;}
case 42:
#line 318 "parser.y"
{ yyval.list = NULL; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 320 "parser.y"


static int
return_cellref (char *p)
{
	CellRef   ref;
	ExprTree *e;

	if (!cellref_get (&ref, p, parser_col, parser_row))
		return 0;

	/*  Ok, parsed successfully, create the return value */
	e = p_new (ExprTree);
	e->ref_count = 1;

	e->oper  = OPER_VAR;
	e->u.ref = ref;

	yylval.tree = e;

	return CELLREF;
}

static int
return_sheetref (Sheet *sheet)
{
	yylval.sheetref = sheet;
	return SHEETREF;
}

static int
make_string_return (char const *string, gboolean const possible_number)
{
	ExprTree *e;
	Value *v;
	double fv;
	char *format;

	e = p_new (ExprTree);
	e->ref_count = 1;

	v = v_new ();
	/*
	 * Try to match the entered text against any
	 * of the known number formating codes, if this
	 * succeeds, we store this as a float + format,
	 * otherwise, we return a string.
	 * Be extra careful with empty strings (""),  They may
	 * match some formats ....
	 */
	if (possible_number && string[0] != '\0' &&
	    format_match (string, &fv, &format)){
		v->type = VALUE_FLOAT;
		v->v.v_float = fv;
		if (parser_desired_format && *parser_desired_format == NULL)
			*parser_desired_format = format;
	} else {
		v->v.str = string_get (string);
		v->type = VALUE_STRING;
	}
	
	e->oper = OPER_CONSTANT;
	e->u.constant = v;
	
	yylval.tree = e;

	return STRING;
}

static int
return_symbol (Symbol *sym)
{
	ExprTree *e = p_new (ExprTree);
	int type = STRING;
	
	e->ref_count = 1;
	symbol_ref (sym);
	
	switch (sym->type){
	case SYMBOL_FUNCTION:
		e->oper = OPER_FUNCALL;
		type = FUNCALL;
		e->u.function.symbol = sym;
		e->u.function.arg_list = NULL;
		break;
		
	case SYMBOL_VALUE:
	case SYMBOL_STRING: {
		Value *v, *dv;
		
		/* Make a copy of the value */
		dv = (Value *) sym->data;
		v = v_new ();
		value_copy_to (v, dv);
		
		e->oper = OPER_CONSTANT;
		e->u.constant = v;
		type = CONSTANT;
		break;
	}
	
	} /* switch */

	register_symbol (sym);
	yylval.tree = e;

	return type;
}

static int
return_name (ExprName *exprn)
{
	ExprTree *e = p_new (ExprTree);
	e->ref_count = 1;

	e->oper = OPER_NAME;
	e->u.name = exprn;
	yylval.tree = e;

	return CONSTANT;
}

/**
 * try_symbol:
 * @string: the string to try.
 * @try_cellref_and_number: If it may be a cellref or a number.
 *
 * Attempts to figure out what @string refers to.
 * if @try_cellref_and_number is TRUE it will also attempt to match the
 * string as a cellname reference or a number.
 */
static int
try_symbol (char *string, gboolean try_cellref_and_number)
{
	Symbol *sym;
	int v;

	if (try_cellref_and_number){
		v = return_cellref (string);
		if (v)
			return v;
	}

	sym = symbol_lookup (global_symbol_table, string);
	if (sym)
		return return_symbol (sym);
	else {
		Sheet *sheet;

		sheet = sheet_lookup_by_name (parser_wb, string);
		if (sheet)
			return return_sheetref (sheet);
	}
	
	{ /* Name ? */
		/*
		 * FIXME: we need a good bit of work to get sheet
		 * scope names working well
		 */
		ExprName *name = expr_name_lookup (parser_wb, NULL,
						   string);
		if (name)
			return return_name (name);
	}

	return make_string_return (string, try_cellref_and_number);
}

int yylex (void)
{
	int c;
	const char *p, *tmp;
	int is_float, digits;

        while(isspace ((unsigned char)*parser_expr))
                parser_expr++;

	c = *parser_expr++;
        if (c == '(' || c == ')')
                return c;

	if (c == parser_separator)
		return SEPARATOR;
	
	/* Translate locale's decimal marker into a dot.  */
	if (c == parser_decimal_point)
		c = '.';

	switch (c){
        case '0': case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9': case '.': {
		ExprTree *e = p_new (ExprTree);
		Value *v = v_new ();

		e->ref_count = 1;
		is_float = c == '.';
		p = parser_expr-1;
		tmp = parser_expr;

		digits = 1;
		while (isdigit ((unsigned char)*tmp) ||
		       (!is_float && *tmp == parser_decimal_point && ++is_float)){
			tmp++;
			digits++;
		}

		/* Can't store it in a gint32 */
		is_float |= (digits > 9);

		if (*tmp == 'e' || *tmp == 'E') {
			is_float = 1;
			tmp++;
			if (*tmp == '-' || *tmp == '+')
				tmp++;
			while (isdigit ((unsigned char)*tmp))
				tmp++;
		}

		/* Ok, we have skipped over a number, now load its value */
		if (is_float) {
			v->type = VALUE_FLOAT;
			float_get_from_range (p, tmp, &v->v.v_float);
		} else {
			v->type = VALUE_INTEGER;
			int_get_from_range (p, tmp, &v->v.v_int);
		}

		/* Return the value to the parser */
		e->oper = OPER_CONSTANT;
		e->u.constant = v;
		yylval.tree = e;

		parser_expr = tmp;
		return NUMBER;
	}
	case '\'':
	case '"': {
		char *string, *s;
		int v;
		char quotes_end = c;
		
                p = parser_expr;
                while(*parser_expr && *parser_expr != quotes_end) {
                        if (*parser_expr == '\\' && parser_expr [1])
                                parser_expr++;
                        parser_expr++;
                }
                if(!*parser_expr){
                        parser_error = PARSE_ERR_NO_QUOTE;
                        return ERROR;
                }
		
		s = string = (char *) alloca (1 + parser_expr - p);
		while (p != parser_expr){
			if (*p== '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;
			
		}
		*s = 0;
		parser_expr++;

		v = try_symbol (string, FALSE);
		return v;
	}
	}
	
	if (isalpha ((unsigned char)c) || c == '_' || c == '$'){
		const char *start = parser_expr - 1;
		char *str;
		int  len;
		
		while (isalnum ((unsigned char)*parser_expr) || *parser_expr == '_' ||
		       *parser_expr == '$' || *parser_expr == '.')
			parser_expr++;

		len = parser_expr - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return try_symbol (str, TRUE);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*parser_expr == '='){
			parser_expr++;
			return LTE;
		}
		if (*parser_expr == '>'){
			parser_expr++;
			return NE;
		}
		return c;
	}
	
	if (c == '>'){
		if (*parser_expr == '='){
			parser_expr++;
			return GTE;
		}
		return c;
	}
	
	return c;
}

int
yyerror (char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

static void
alloc_register (AllocRec *a_info)
{
	alloc_list = g_list_prepend (alloc_list, a_info);
}

static void
register_symbol (Symbol *sym)
{
	AllocRec *a_info = g_new (AllocRec, 1);

	a_info->type = ALLOC_SYMBOL;
	a_info->data = sym;
	alloc_register (a_info);
}

void *
alloc_buffer (int size)
{
	AllocRec *a_info = g_new (AllocRec, 1);
	void *res = g_malloc (size);

	a_info->type = ALLOC_BUFFER;
	a_info->data = res;
	alloc_register (a_info);

	return res;
}

static Value *
v_new (void)
{
	AllocRec *a_info = g_new (AllocRec, 1);
	Value *res = g_new (Value, 1);

	a_info->type = ALLOC_VALUE;
	a_info->data = res;
	alloc_register (a_info);

	return res;
}

static void
alloc_clean (void)
{
	GList *l = alloc_list;
	
	for (; l; l = l->next) {
		AllocRec *rec = l->data;

		switch (rec->type){
		case ALLOC_BUFFER:
			g_free (rec->data);
			break;
			
		case ALLOC_SYMBOL:
			symbol_unref ((Symbol *)rec->data);
			break;

		case ALLOC_VALUE:
			value_release ((Value *)rec->data);
			break;
			
		case ALLOC_LIST:
			g_list_free ((GList *) rec->data);
			break;
		}
		g_free (rec);
	}

	g_list_free (alloc_list);
	alloc_list = NULL;
}

static void
alloc_list_free (void)
{
	GList *l = alloc_list;
	
	for (; l; l = l->next)
		g_free (l->data);

	g_list_free (alloc_list);
	alloc_list = NULL;
}

static void
alloc_glist (GList *list)
{
	AllocRec *a_info = g_new (AllocRec, 1);

	a_info->type = ALLOC_LIST;
	a_info->data = list;
	alloc_register (a_info);
}

static void
forget (AllocType type, void *data)
{
	GList *l;

	for (l = alloc_list; l; l = l->next) {
		AllocRec *a_info = (AllocRec *) l->data;

		if (a_info->type == type && a_info->data == data) {
			alloc_list = g_list_remove_link (alloc_list, l);
			g_list_free_1 (l);
			g_free (a_info);
			return;
		}
	}
}

static void
forget_glist (GList *list)
{
	forget (ALLOC_LIST, list);
}

static void
v_forget (Value *v)
{
	forget (ALLOC_VALUE, v);
}

static void
forget_tree (ExprTree *tree)
{
	expr_tree_unref (tree);
	forget (ALLOC_BUFFER, tree);
}

static void
forget_array (GList *array)
{
	GList *l = array;

	while (l) {
		forget_glist (l->data);
		l = g_list_next (l);
	}
	forget_glist (array);
}

ParseErr
gnumeric_expr_parser (const char *expr, const ParsePosition *pp,
		      const char **desired_format, ExprTree **result)
{
	struct lconv *locinfo;

	g_return_val_if_fail (pp, PARSE_ERR_UNKNOWN);
	g_return_val_if_fail (expr, PARSE_ERR_UNKNOWN);
	g_return_val_if_fail (result, PARSE_ERR_UNKNOWN);

	parser_error = PARSE_OK;
	parser_expr = expr;
	parser_wb    = pp->wb;
	parser_col   = pp->col;
	parser_row   = pp->row;
	parser_desired_format = desired_format;
	parser_result = result;

	if (parser_desired_format)
		*parser_desired_format = NULL;

	locinfo = localeconv ();
	if (locinfo->decimal_point && locinfo->decimal_point[0] &&
	    locinfo->decimal_point[1] == 0)
		parser_decimal_point = locinfo->decimal_point[0];
	else
		parser_decimal_point = '.';

	if (parser_decimal_point == ',') {
		parser_separator = ';';
		parser_array_col_separator = '\\'; /* ! */
	} else {
		parser_separator = ',';
		parser_array_col_separator = ',';
	}

	yyparse ();

	if (parser_error == PARSE_OK)
		alloc_list_free ();
	else {
		alloc_clean ();
		*parser_result = NULL;
	}

	return parser_error;
}
