/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

/**
 * SECTION: 
 * @short_description: #GnomeScanPaperSizeWidget class
 * 
 **/
#include <glib/gi18n.h>
#include "gnome-scan-paper-size-widget.h"
#include "gnome-scan-param-specs.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidgetPrivate))

typedef struct _GnomeScanPaperSizeWidgetPrivate GnomeScanPaperSizeWidgetPrivate;
struct _GnomeScanPaperSizeWidgetPrivate
{
	GtkListStore	*paper_names;
	GtkWidget		*combo;
	GtkWidget		*label;
};

enum
	{
		COL_DISPLAY_NAME,
		COL_PS,
		N_COLUMNS
	};

GS_DEFINE_PARAM_WIDGET (GnomeScanPaperSizeWidget, gnome_scan_paper_size_widget);

static void
gnome_scan_paper_size_widget_init (GnomeScanPaperSizeWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_paper_size_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_paper_size_widget_parent_class)->finalize (object);
}

static void
gspsw_update_label (GnomeScanPaperSizeWidget *gspsw, GtkPaperSize *ps)
{
	GnomeScanPaperSizeWidgetPrivate *priv = GET_PRIVATE (gspsw);
	gchar *display_name = NULL;
	
	display_name = g_strdup_printf (_("%.0f x %.0f mm"),
									gtk_paper_size_get_width (ps, GTK_UNIT_MM),
									gtk_paper_size_get_height (ps, GTK_UNIT_MM));
	
	gtk_label_set_text (GTK_LABEL (priv->label),
						display_name);
	
	g_free (display_name);
}

static void
gspsw_selected (GtkComboBox *combo, GnomeScanPaperSizeWidget *gspsw)
{
	GnomeScanPaperSizeWidgetPrivate *priv = GET_PRIVATE (gspsw);
	GtkTreeIter iter;
	GtkPaperSize *ps;
	
	gtk_combo_box_get_active_iter (combo, &iter);
	gtk_tree_model_get (GTK_TREE_MODEL (priv->paper_names), &iter,
						COL_PS, &ps,
						-1);
	gspsw_update_label (gspsw, ps);
	g_value_set_boxed (GNOME_SCAN_PARAM_WIDGET (gspsw)->value, ps);
	gnome_scan_param_widget_changed (GNOME_SCAN_PARAM_WIDGET (gspsw));

	/* update "origin" if needed */
#define settings GNOME_SCAN_PARAM_WIDGET (gspsw)->settings
	if (g_str_equal (gtk_paper_size_get_name (ps), "maximal")) {
		GdkPoint *o = gnome_scan_settings_get_pointer (settings, "origin");
		if (!o) {
			o = g_new0 (GdkPoint, 1);
		}
		o->x = o->y = 0;
		gnome_scan_settings_set_pointer (settings, "origin", o);
	}
#undef settings
}


static void
gnome_scan_paper_size_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanPaperSizeWidgetPrivate *priv = GET_PRIVATE (gspw);
	GtkWidget *box;
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	GtkPaperSize *ps;
	GSList *node;
	gint i;
	
	gspw->shows_label = TRUE;
	gspw->shows_unit = TRUE;
	
	/* store */
	priv->paper_names = gtk_list_store_new (N_COLUMNS,
											G_TYPE_STRING,
											GTK_TYPE_PAPER_SIZE);
	
	node = GS_PARAM_SPEC_PAPER_SIZE (gspw->pspec)->enumeration;
	for (; node; node = node->next) {
		ps = node->data;
		gtk_list_store_append (priv->paper_names, &iter);
		gtk_list_store_set (priv->paper_names, &iter,
							COL_DISPLAY_NAME, gtk_paper_size_get_display_name(ps),
							COL_PS, ps,
							-1);
	}
	
	/* combo */
	priv->combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL (priv->paper_names));

	renderer = gtk_cell_renderer_text_new();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (priv->combo), renderer, TRUE);
	gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (priv->combo), renderer,
								   "text", COL_DISPLAY_NAME);
	
	/* label */
	priv->label = gtk_label_new (NULL);
	
	box = gtk_vbox_new (FALSE, 4);
	gtk_box_pack_start (GTK_BOX (box), priv->combo, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), priv->label, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (gspw), box, FALSE, FALSE, 0);
	
	
	g_signal_connect (GET_PRIVATE (gspw)->combo, "changed",
					  (GCallback) gspsw_selected,
					  GNOME_SCAN_PAPER_SIZE_WIDGET (gspw));
}

static void
gnome_scan_paper_size_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	GnomeScanPaperSizeWidgetPrivate *priv = GET_PRIVATE (gspw);
	GtkTreeIter iter;
	GtkPaperSize *ps = NULL;
	GtkPaperSize *def = g_value_get_boxed (value);

	/* loop model searching the one selected */
	gtk_tree_model_get_iter_first (GTK_TREE_MODEL (priv->paper_names), &iter);
	for (; gtk_list_store_iter_is_valid (priv->paper_names, &iter)
			 ; gtk_tree_model_iter_next (GTK_TREE_MODEL (priv->paper_names), &iter)) {
		gtk_tree_model_get (GTK_TREE_MODEL (priv->paper_names), &iter,
							COL_PS, &ps,
							-1);
		/* test wether the current paper size is the same as selected */
		if (g_str_equal (gtk_paper_size_get_name (def),
						 gtk_paper_size_get_name (ps))) {

			/* update manual paper size */
			if (g_str_equal (gtk_paper_size_get_name (def), "manual")) {
/* 				g_debug (G_STRLOC ": set paper size to %s:%.2fx%.2f mm", */
/* 						 gtk_paper_size_get_name (def), */
/* 						 gtk_paper_size_get_width (def, GTK_UNIT_MM), */
/* 						 gtk_paper_size_get_height (def, GTK_UNIT_MM)); */
				gtk_list_store_set (priv->paper_names, &iter,
									COL_PS, def,
									-1);
				g_boxed_free (GTK_TYPE_PAPER_SIZE, ps);
				ps = def;
			}
			gtk_combo_box_set_active_iter (GTK_COMBO_BOX (priv->combo), &iter);
			gspsw_update_label (GNOME_SCAN_PAPER_SIZE_WIDGET (gspw), def);
			break;
		}
	}
}
