/* FlegitaShoot - A ugly hack to shoot libgnomescanui widget
 *
 * shoot.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <gnomescanui.h>

typedef struct {
  GnomeScanContext	*context;
  GtkWidget 		*window;
  GtkWidget 		*box;
  GtkWidget		*apply;
  GSList    		*widgets;
  gint			set;
} Infos;

void
delete_event (GtkWidget *window,
	      GdkEvent *event,
	      GnomeScanContext *context)
{
  gtk_main_quit ();
}

void
pack_widget (GtkWidget *widget,
	     GtkWidget *box)
{
  if (!GTK_IS_WINDOW (widget)) {
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 0);
  }
  gtk_widget_show_all (widget);
}

/* Shoot a widget and store it in a PNG at $(HOME) using the object name is filename. */
void
shoot_widget (GtkWidget *widget)
{
  GdkPixbuf *pixbuf;
  GdkDrawable *drawable;
  GtkAllocation alloc;
  GdkRectangle rect;
  gint x, y, width, height;
  gchar *basename, *filename;

  if (GTK_IS_WINDOW (widget)) {
    gdk_window_get_frame_extents (widget->window, &rect);
    x = rect.x;
    y = rect.y;
    width = rect.width;
    height = rect.height;
    drawable = gdk_get_default_root_window ();
/*     gtk_window_present (GTK_WINDOW (widget)); */
  }
  else {
    alloc = GTK_WIDGET (widget)->allocation;
    x = alloc.x;
    y = alloc.y;
    width = alloc.width;
    height = alloc.height;
    drawable = GDK_DRAWABLE (widget->window);
    gtk_widget_grab_focus (widget);
  }

  while (gdk_events_pending ()) gtk_main_iteration ();
  gdk_flush ();

  g_debug ("%s %p %ix%i+%i+%i", G_OBJECT_TYPE_NAME (widget), widget, width, height, x, y);

  pixbuf = gdk_pixbuf_get_from_drawable (NULL,
					 drawable,
					 gdk_colormap_get_system (),
					 x, y,
					 0, 0,
					 width, height);

  basename =  g_strconcat (G_OBJECT_TYPE_NAME (widget), ".png", NULL);
  filename = g_build_filename (g_get_home_dir (), basename, NULL);

  gdk_pixbuf_save (pixbuf,
		   filename,
		   "png",
		   NULL,
		   NULL);

  g_free (basename);
  g_free (filename);

  g_object_unref (pixbuf);
}

void
remove_widget (GtkWidget *widget,
	       GtkWidget *box)
{
  g_debug ("Remove %p", widget);
  g_object_ref (widget);
  if (GTK_IS_WINDOW (widget)) {
    gtk_widget_hide (widget);
    gtk_widget_destroy (widget);
    if (GNOME_IS_SCAN_DIALOG (widget)) {
      gtk_main_quit ();
    }
  }
  else {
    gtk_container_remove (GTK_CONTAINER (box), widget);
  }
}

void
prepare_shoot (GtkButton *button,
	       Infos *infos)
{
  GtkWidget *widget;

  if (infos->widgets) {
    g_slist_foreach (infos->widgets, (GFunc) remove_widget, infos->box);
    g_slist_free (infos->widgets);
    infos->widgets = NULL;
  }
  switch (infos->set) {
  case 0:
    infos->context = gnome_scan_context_new ();
    infos->widgets = NULL;
    infos->widgets = g_slist_append (infos->widgets, gnome_scan_dialog_new (infos->context, GTK_WINDOW (infos->window)));
    infos->widgets = g_slist_append (infos->widgets, gnome_scan_resolution_selector_new (infos->context));
    infos->widgets = g_slist_append (infos->widgets, gnome_scan_source_selector_new (infos->context));
    widget = GTK_WIDGET (g_object_new (GNOME_TYPE_SCAN_OPTION_WIDGET, "context", infos->context, NULL));
    gnome_scan_option_widget_set_label (GNOME_SCAN_OPTION_WIDGET (widget), "option");
    gnome_scan_option_widget_show_label (GNOME_SCAN_OPTION_WIDGET (widget));
    infos->widgets = g_slist_append (infos->widgets, widget);
    break;
  case 1:
    infos->context = gnome_scan_context_new ();
    infos->widgets = NULL;
    infos->widgets = g_slist_append (infos->widgets, gnome_scan_preview_area_new (infos->context));
    infos->widgets = g_slist_append (infos->widgets, gnome_scan_acquisition_dialog_new (infos->context, GTK_WINDOW (infos->window)));
/*     break; */
/*   case 2: */
/*     infos->context = gnome_scan_context_new (); */
/*     infos->widgets = NULL; */
/*     infos->widgets = g_slist_append (infos->widgets, gnome_scanner_selector_new (infos->context)); */
    break;
/*   case 3: */
/*     infos->context = gnome_scan_context_new (); */
/*     infos->widgets = NULL; */
/*     break; */
/*   case 4: */
/*     infos->context = gnome_scan_context_new (); */
/*     infos->widgets = NULL; */
/*     break; */
  default:
    gtk_main_quit ();
    break;
  }

  g_debug ("New set");
  g_slist_foreach (infos->widgets, (GFunc) pack_widget, infos->box);
  gnome_scan_context_probe_scanners (infos->context);
  gnome_scan_context_set_resolution (infos->context, 300.);
  gtk_widget_set_sensitive (infos->apply, TRUE);

  while (gdk_events_pending ()) gtk_main_iteration ();

  infos->set++;
  return;
}

shoot_widgets (GtkButton *button,
	       Infos *infos)
{
  g_slist_foreach (infos->widgets, (GFunc) shoot_widget, NULL);
  g_slist_foreach (infos->widgets, (GFunc) remove_widget, infos->box);
  g_slist_free (infos->widgets);
  infos->widgets = NULL;
  gnome_scan_context_destroy (infos->context);
}

gint
main (int argc, gchar **argv)
{
  Infos *infos = g_new0 (Infos, 1);
  GtkWidget *widget, *box;

/*   gnome_program_init ("flegita-shoot", VERSION, LIBGNOMEUI_MODULE, argc, argv, NULL); */
  gtk_init (&argc, &argv);
  gnome_scan_ui_init ();

  infos->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (GTK_WINDOW (infos->window), 50, 50);
  gtk_window_set_position (GTK_WINDOW (infos->window), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_title (GTK_WINDOW (infos->window), _("GnomeScanUI screenshot tool"));
  gtk_window_set_icon_name (GTK_WINDOW (infos->window), "gnomescan");
  gtk_container_set_border_width (GTK_CONTAINER (infos->window), 6);

  /* all widgets to shoot */
  infos->box = gtk_vbox_new (FALSE, 6);
  gtk_container_add (GTK_CONTAINER (infos->window), infos->box);

  box = gtk_hbutton_box_new ();
  infos->apply = gtk_button_new_from_stock (GTK_STOCK_APPLY);
  gtk_box_pack_end (GTK_BOX (box), infos->apply, FALSE, FALSE, 0);
  g_signal_connect (GTK_BUTTON (infos->apply),
		    "clicked",
		    (GCallback) shoot_widgets,
		    infos);

  widget = gtk_button_new_from_stock (GTK_STOCK_GO_FORWARD);
  gtk_box_pack_end (GTK_BOX (box), widget, FALSE, FALSE, 0);
  g_signal_connect (GTK_BUTTON (widget),
		    "clicked",
		    (GCallback) prepare_shoot,
		    infos);

  gtk_box_pack_end (GTK_BOX (infos->box), box, FALSE, FALSE, 0);
  gtk_widget_show_all (infos->window);

  g_signal_connect (infos->window,
		    "delete-event",
		    (GCallback) delete_event,
		    infos->context);

  gtk_main ();

  gtk_widget_destroy (infos->window);
  g_free (infos);

  return (0);
}
