/* Generated by GOB (v0.93.4) on Tue May  9 21:56:17 2000
   (do not edit directly) */

#define GOB_VERSION_MAJOR 0
#define GOB_VERSION_MINOR 93
#define GOB_VERSION_PATCHLEVEL 4

#include "gnome-pilot-conduit-config.h"

#include "gnome-pilot-conduit-config-private.h"


#line 32 "gnome-pilot-conduit-config.gob"

#include <config.h>

#line 18 "gnome-pilot-conduit-config.c"
/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_CONFIG(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_CONFIG(x)
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_CONFIG_CLASS(x)

/* here are local prototypes */
static void gnome_pilot_conduit_config_init (GnomePilotConduitConfig *o) G_GNUC_UNUSED;
static void gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass *c) G_GNUC_UNUSED;
static void gnome_pilot_conduit_config_finalize (GtkObject *o) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkObjectClass *parent_class = NULL;

guint
gnome_pilot_conduit_config_get_type (void)
{
	static guint type = 0;

	if (!type) {
		static const GtkTypeInfo info = {
			"GnomePilotConduitConfig",
			sizeof (GnomePilotConduitConfig),
			sizeof (GnomePilotConduitConfigClass),
			(GtkClassInitFunc) gnome_pilot_conduit_config_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_config_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		type = gtk_type_unique (gtk_object_get_type(), &info);
	}

	return type;
}


#ifdef __GNUC__
static const typeof(&gnome_pilot_conduit_config_new) new __attribute__ ((__unused__)) = gnome_pilot_conduit_config_new;
#define new(args...) gnome_pilot_conduit_config_new(##args)
static const typeof(&gnome_pilot_conduit_config_destroy) destroy __attribute__ ((__unused__)) = gnome_pilot_conduit_config_destroy;
#define destroy(args...) gnome_pilot_conduit_config_destroy(##args)
static const typeof(&gnome_pilot_conduit_config_load_config) load_config __attribute__ ((__unused__)) = gnome_pilot_conduit_config_load_config;
#define load_config(args...) gnome_pilot_conduit_config_load_config(##args)
static const typeof(&gnome_pilot_conduit_config_save_config) save_config __attribute__ ((__unused__)) = gnome_pilot_conduit_config_save_config;
#define save_config(args...) gnome_pilot_conduit_config_save_config(##args)
static const typeof(&gnome_pilot_conduit_config_is_enabled) is_enabled __attribute__ ((__unused__)) = gnome_pilot_conduit_config_is_enabled;
#define is_enabled(args...) gnome_pilot_conduit_config_is_enabled(##args)
static const typeof(&gnome_pilot_conduit_config_enable) enable __attribute__ ((__unused__)) = gnome_pilot_conduit_config_enable;
#define enable(args...) gnome_pilot_conduit_config_enable(##args)
static const typeof(&gnome_pilot_conduit_config_enable_with_first_sync) enable_with_first_sync __attribute__ ((__unused__)) = gnome_pilot_conduit_config_enable_with_first_sync;
#define enable_with_first_sync(args...) gnome_pilot_conduit_config_enable_with_first_sync(##args)
static const typeof(&gnome_pilot_conduit_config_remove_first_sync) remove_first_sync __attribute__ ((__unused__)) = gnome_pilot_conduit_config_remove_first_sync;
#define remove_first_sync(args...) gnome_pilot_conduit_config_remove_first_sync(##args)
static const typeof(&gnome_pilot_conduit_config_disable) disable __attribute__ ((__unused__)) = gnome_pilot_conduit_config_disable;
#define disable(args...) gnome_pilot_conduit_config_disable(##args)
#else /* __GNUC__ */
static GnomePilotConduitConfig *(* new) (GnomePilotConduitManagement *gpcm, guint32 pilot_id) = gnome_pilot_conduit_config_new;
static void (* destroy) (GnomePilotConduitConfig *self) = gnome_pilot_conduit_config_destroy;
static int (* load_config) (GnomePilotConduitConfig *self) = gnome_pilot_conduit_config_load_config;
static int (* save_config) (GnomePilotConduitConfig *self) = gnome_pilot_conduit_config_save_config;
static gboolean (* is_enabled) (GnomePilotConduitConfig *self, GnomePilotConduitSyncType *sync_type) = gnome_pilot_conduit_config_is_enabled;
static void (* enable) (GnomePilotConduitConfig *self, GnomePilotConduitSyncType sync_type) = gnome_pilot_conduit_config_enable;
static void (* enable_with_first_sync) (GnomePilotConduitConfig *self, GnomePilotConduitSyncType sync_type, GnomePilotConduitSyncType first_sync_type, gboolean slow) = gnome_pilot_conduit_config_enable_with_first_sync;
static void (* remove_first_sync) (GnomePilotConduitConfig *self) = gnome_pilot_conduit_config_remove_first_sync;
static void (* disable) (GnomePilotConduitConfig *self) = gnome_pilot_conduit_config_disable;
#endif /* __GNUC__ */

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomePilotConduitConfig *)gtk_type_new(gnome_pilot_conduit_config_get_type()))

static void 
gnome_pilot_conduit_config_init (GnomePilotConduitConfig *o)
{
	o->_priv = g_new0 (GnomePilotConduitConfigPrivate, 1);
return;
}
static void 
gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass *c)
{
	GtkObjectClass *gtk_object_class = (GtkObjectClass *)c;

	parent_class = gtk_type_class (gtk_object_get_type ());

	gtk_object_class->finalize = gnome_pilot_conduit_config_finalize;
return;
}



#line 49 "gnome-pilot-conduit-config.gob"
GnomePilotConduitConfig *
gnome_pilot_conduit_config_new (GnomePilotConduitManagement *gpcm, guint32 pilot_id)
{
#line 113 "gnome-pilot-conduit-config.c"
{
#line 50 "gnome-pilot-conduit-config.gob"
	
		GtkObject *ret = NULL;
		GnomePilotConduitConfig *obj;

		ret = GTK_OBJECT(GET_NEW);
		obj = SELF(ret);
		obj->_priv->pilot_id = pilot_id;
		obj->_priv->gpcm = gpcm;

		return obj;
	}}
#line 127 "gnome-pilot-conduit-config.c"

#line 63 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_destroy (GnomePilotConduitConfig *self)
{
#line 63 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 63 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 137 "gnome-pilot-conduit-config.c"
{
#line 64 "gnome-pilot-conduit-config.gob"
	
		gtk_object_destroy(GTK_OBJECT(self));
	}}
#line 143 "gnome-pilot-conduit-config.c"

#line 73 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_load_config (GnomePilotConduitConfig *self)
{
#line 73 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 73 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 153 "gnome-pilot-conduit-config.c"
{
#line 74 "gnome-pilot-conduit-config.gob"
	
		gchar *prefix,*tmp;

		if(is_enabled(self,NULL)==TRUE) {
			prefix = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
						 self->_priv->pilot_id,
				                 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			gnome_config_push_prefix(prefix);
			tmp = gnome_config_get_string("sync_type");
			if (tmp) {
				self->sync_type = gnome_pilot_conduit_sync_type_str_to_int(tmp);
			} else {
				g_warning("conduit has no sync_type, synchronization will skip this conduit");
				self->sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			tmp = gnome_config_get_string("first_sync_type");
			if (tmp) {
				self->first_sync_type = gnome_pilot_conduit_sync_type_str_to_int(tmp);
			} else {
				self->first_sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			self->first_slow = gnome_config_get_bool("slow_sync");
			gnome_config_pop_prefix();
			g_free(prefix);
		} else 
			return 0;
		return 1;
	}}
#line 186 "gnome-pilot-conduit-config.c"

#line 105 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_save_config (GnomePilotConduitConfig *self)
{
#line 105 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 105 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 196 "gnome-pilot-conduit-config.c"
{
#line 106 "gnome-pilot-conduit-config.gob"
	
		gchar *prefix;

		if(is_enabled(self,NULL)==TRUE) {
			prefix = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
						 self->_priv->pilot_id,
				                 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			gnome_config_push_prefix(prefix);
			gnome_config_set_string("sync_type",
						gnome_pilot_conduit_sync_type_int_to_str(self->sync_type));
			gnome_config_set_string("first_sync_type",
						gnome_pilot_conduit_sync_type_int_to_str(self->first_sync_type));
			if(self->first_sync_type==GnomePilotConduitSyncTypeSynchronize) 
			        gnome_config_set_bool("slow_sync",self->first_slow);
			else
			        gnome_config_clean_key("slow_sync");
			gnome_config_pop_prefix();
			gnome_config_sync();
			g_free(prefix);
		} else 
			return 0;
		return 1;
	}}
#line 222 "gnome-pilot-conduit-config.c"

#line 137 "gnome-pilot-conduit-config.gob"
gboolean 
gnome_pilot_conduit_config_is_enabled (GnomePilotConduitConfig *self, GnomePilotConduitSyncType *sync_type)
{
#line 137 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 137 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (gboolean )0);
#line 232 "gnome-pilot-conduit-config.c"
{
#line 139 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		int num_conduits,cnt;
		gchar **conduit_name;
		gboolean retval;
		
		retval = FALSE;
		
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",
				      self->_priv->pilot_id);
		/* g_message("prefix = %s",tmp); */
		
		/* load the list */
		gnome_config_push_prefix(tmp);
		gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
		gnome_config_pop_prefix();
		
		/* g_message("number_of_conduits = %d",num_conduits); */
		
		/* loop, compare and free */
		for(cnt=0;cnt<num_conduits;cnt++) {
			/* g_message("g_str_equal(%s,%s)",
			   conduit_name[cnt] ,
			   gnome_pilot_conduit_management_get_id(self->_priv->gpcm)); */
			if(g_str_equal(conduit_name[cnt] ,gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("match on %s, it is enabled",conduit_name[cnt]); */
				if(sync_type) {
					gchar *newpfx,*tmpstr;
					newpfx = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/sync_type",
								 self->_priv->pilot_id,
								 gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
					tmpstr = gnome_config_get_string(newpfx);
					/* g_message("%s says %s",newpfx,tmpstr); */
					(*sync_type) = gnome_pilot_conduit_sync_type_str_to_int(tmpstr);
					g_free(newpfx);
					g_free(tmpstr);
				}
				retval = TRUE;
			} 
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		g_free(tmp);
		return retval;
	}}
#line 280 "gnome-pilot-conduit-config.c"

#line 187 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable (GnomePilotConduitConfig *self, GnomePilotConduitSyncType sync_type)
{
#line 187 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 187 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 290 "gnome-pilot-conduit-config.c"
{
#line 189 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		char **conduit_name;
		char **conduit_name_copy;
		int num_conduits,cnt;
	
		/* enable conduit, if it wasn't, otherwise, just write
		   the sync type in case it was changed. */
		if(is_enabled(self,NULL)==FALSE) {
			tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",self->_priv->pilot_id);
			/* g_message("prefix = %s",tmp); */
	
			/* load the list of conduits */
			gnome_config_push_prefix(tmp);
			gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
			/* g_message("num_conduits = %d",num_conduits); */
	
			/* copy the list and attach new conduit */
			conduit_name_copy = g_new0(gchar*,num_conduits+2);
			for(cnt=0;cnt<num_conduits;cnt++) {
				/* g_message("duping %d %s",cnt,conduit_name[cnt]); */
				conduit_name_copy[cnt] = g_strdup(conduit_name[cnt]);
				g_free(conduit_name[cnt]);
			}
			g_free(conduit_name);
			/* g_message("adding %s as element %d",gnome_pilot_conduit_management_get_id(self->_priv->gpcm),num_conduits); */ 
			conduit_name_copy[num_conduits] = g_strdup(gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
	
			/* write new list */
			/* g_message("writing new conduits list, size %d",num_conduits+1); */
			gnome_config_set_vector("conduits",num_conduits+1,(const char**)conduit_name_copy);
	
			/* free the copy */
			/* g_message("freeing %d items",num_conduits+1); */
			for(cnt=0;cnt<num_conduits+1;cnt++) {
				/* g_message("should contain %s",conduit_name_copy[cnt]); */
				g_free(conduit_name_copy[cnt]);
			}
			g_free(conduit_name_copy);
	
			gnome_config_pop_prefix();
	
			g_free(tmp);
		}

		/* make section for conduit */
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		/* g_message("prefix = %s",tmp); */
		gnome_config_push_prefix(tmp);
		gnome_config_set_string("sync_type",
					gnome_pilot_conduit_sync_type_int_to_str(sync_type));
		gnome_config_pop_prefix();
		gnome_config_sync();
		g_free(tmp);
	}}
#line 350 "gnome-pilot-conduit-config.c"

#line 249 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable_with_first_sync (GnomePilotConduitConfig *self, GnomePilotConduitSyncType sync_type, GnomePilotConduitSyncType first_sync_type, gboolean slow)
{
#line 249 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 249 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 360 "gnome-pilot-conduit-config.c"
{
#line 253 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		
		enable(self,sync_type);

		/* add the first_sync info */
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		gnome_config_push_prefix(tmp);
		gnome_config_set_string("first_sync_type",
					gnome_pilot_conduit_sync_type_int_to_str(first_sync_type));
		if(first_sync_type==GnomePilotConduitSyncTypeSynchronize) 
			gnome_config_set_bool("slow_sync",slow);
		else
			gnome_config_clean_key("slow_sync");
		gnome_config_pop_prefix();
		gnome_config_sync();
		g_free(tmp);
	}}
#line 383 "gnome-pilot-conduit-config.c"

#line 275 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_remove_first_sync (GnomePilotConduitConfig *self)
{
#line 275 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 275 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 393 "gnome-pilot-conduit-config.c"
{
#line 276 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		
		if (is_enabled(self,NULL)) {
			/* add the first_sync info */
			tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
					      self->_priv->pilot_id,
					      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
			if (gnome_config_has_section(tmp)) {
				gnome_config_push_prefix(tmp);
				gnome_config_clean_key("first_sync_type");
				gnome_config_clean_key("slow_sync");
				gnome_config_pop_prefix();
			}
			gnome_config_sync();
			g_free(tmp);
		}

		
	}}
#line 416 "gnome-pilot-conduit-config.c"

#line 298 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_disable (GnomePilotConduitConfig *self)
{
#line 298 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 298 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 426 "gnome-pilot-conduit-config.c"
{
#line 299 "gnome-pilot-conduit-config.gob"
	
		gchar *tmp;
		gchar **conduit_name;
		char **conduit_name_copy;
		int num_conduits,num_conduits_copy,cnt;
		
		if(is_enabled(self,NULL)==FALSE) return;

		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/General/",self->_priv->pilot_id);
		
		/* load the list of conduits */
		gnome_config_push_prefix(tmp);
		gnome_config_get_vector("conduits",&num_conduits,&conduit_name);
		
		/* copy the list, excluding the one to delete, num_conduits is > 0 since is_enables succeeded */
		conduit_name_copy = g_new0(char*,num_conduits);
		num_conduits_copy = 0;
		for(cnt=1;cnt<num_conduits;cnt++) {
			if(g_strcasecmp(conduit_name[cnt],gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("keeping %d:%s",cnt,conduit_name[cnt]); */
				conduit_name_copy[num_conduits_copy]=g_strdup(conduit_name[cnt]);
				num_conduits_copy++;
			} else {
				/* g_message("skipping %d:%s",cnt,conduit_name[cnt]); */
			}
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		
		/* save new list */
		/* g_message("num_conduits_copy = %d",num_conduits_copy); */
		if ( num_conduits_copy > 0 )
			gnome_config_set_vector("conduits",num_conduits_copy,(const char**)conduit_name_copy);
		else
			gnome_config_clean_key("conduits");
		
		/* free copy */
		for(cnt=0;cnt<num_conduits_copy;cnt++) g_free(conduit_name_copy[cnt]);
		g_free(conduit_name_copy);
		
		gnome_config_pop_prefix();
		
		/* nuke the conduits config section */
		g_free(tmp);
		tmp = g_strdup_printf("/gnome-pilot.d/conduits%d/%s/",
				      self->_priv->pilot_id,
				      gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
		gnome_config_clean_section(tmp);
		
		gnome_config_sync();
		g_free(tmp);		
	}}
#line 481 "gnome-pilot-conduit-config.c"

static void 
gnome_pilot_conduit_config_finalize (GtkObject *o)
#define PARENT_HANDLER(___o) \
	{ if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(___o); }
{
	GnomePilotConduitConfig *___self = GNOME_PILOT_CONDUIT_CONFIG (o);
	g_free (___self->_priv);
	___self->_priv = NULL;
{
	PARENT_HANDLER (o);
}}
#undef PARENT_HANDLER


#ifndef __GNUC__
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gnome_pilot_conduit_config_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))destroy)();
	((void (*)(void))load_config)();
	((void (*)(void))save_config)();
	((void (*)(void))is_enabled)();
	((void (*)(void))enable)();
	((void (*)(void))enable_with_first_sync)();
	((void (*)(void))remove_first_sync)();
	((void (*)(void))disable)();
	___gnome_pilot_conduit_config_really_bad_hack_to_avoid_warnings();
}
#endif /* __GNUC__ */


#line 353 "gnome-pilot-conduit-config.gob"



#line 525 "gnome-pilot-conduit-config.c"
