#ifndef __EXPENSE_CONDUIT_H__
#define __EXPENSE_CONDUIT_H__

#include <unistd.h>
#include <pi-expense.h>


enum ExpenseOutputFormat { 
  eSimpleFormat, eComplexFormat
};

typedef struct ConduitCfg {
  gchar *dir;
  gchar *dateFormat;
  mode_t dirMode;
  mode_t fileMode;
  enum ExpenseOutputFormat outputFormat;

  guint32 pilotId;
  pid_t child;
} ConduitCfg;

typedef struct ConduitData {
  struct ExpenseAppInfo ai;
  struct ExpensePref pref;
  GnomePilotDBInfo *dbi;
} ConduitData;

#define GET_CONFIG(c) ((ConduitCfg*)(gtk_object_get_data(GTK_OBJECT(c),"conduit_config")))
#define GET_CONDUIT_DATA(c) ((ConduitData*)gtk_object_get_data(GTK_OBJECT(c),"conduit_data"))

#endif /* __EXPENSE_CONDUIT_H__ */
