/* $Id: backup_conduit.h,v 1.21 2000/02/26 08:12:18 vadim Exp $ */
#ifndef __BACKUP_CONDUIT_H__
#define __BACKUP_CONDUIT_H__

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

typedef struct ConduitCfg {
  gchar *backup_dir;
  GList *exclude_files;
  GList *files_in_backup;   /* contains the file in backup, any entries when
                               destroy is called are considered deleted on PDA */
  gboolean remove_deleted;
  gboolean updated_only;
  guint32 pilotId;
  pid_t child;
} ConduitCfg;

#define CONDUIT_CFG(s) ((ConduitCfg*)(s))
#define GET_CFG(s) ((ConduitCfg*)(gtk_object_get_data(GTK_OBJECT(s),"configuration")))


#endif
