#ifndef GPILOTD_CAPPLET_PILOT_H
#define GPILOTD_CAPPLET_PILOT_H

#include <gpilotd/gpilot-userinfo.h>
#include <gpilotd/gpilot-structures.h>
#include <gpilotd/gnome-pilot-conduit.h>

/* variables describing pilotd configuration state */
typedef struct _PilotState PilotState;
struct _PilotState {
	guint32      syncPCid;     /* SyncPCid for this machine */
	/* GPilotUser   *user;*/         /* name of UNIX user for this pilot */
	GList        *pilots;
	GList        *devices;
};


PilotState *newPilotState(void);
PilotState *dupPilotState(PilotState *state);
void freePilotState(PilotState *state);

void copyPilotState(PilotState *dest, PilotState *src);
gint loadPilotState(PilotState **p);
gint savePilotState(PilotState *p);

#endif

