#ifndef __GPILOTD_APP_H
#define __GPILOTD_APP_H

#include <gnome.h>
#include <orb/orbit.h>
#include <gpilotd/gnome-pilot.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*
  type:
  GNOME_Pilot_PilotUser
  GNOME_Pilot_Survival
  GNOME_Pilot_EventType
  
  are defined in gpilotd-lib.h
*/
	
	/*
	  extern GNOME_Pilot_Daemon gpilotddaemon;
	  extern GNOME_Pilot_Client callback_obj;
	  extern CORBA_ORB orb;
	*/
	
  /*
     The following methods are defined by the user application,
     and are used as callbacks by lib-gpilotd */

extern void gpilotd_connect_cb(const gchar*,const GNOME_Pilot_PilotUser*);
extern void gpilotd_disconnect_cb(const gchar*);
extern void gpilotd_request_completed(const gchar *,unsigned long);
extern void gpilotd_userinfo_requested(const gchar *,const GNOME_Pilot_PilotUser*);
extern void gpilotd_sysinfo_requested(const gchar *,const GNOME_Pilot_SysInfo*);
extern void gpilotd_conduit_start(const gchar *id, 
				  const gchar *conduit_name, 
				  const gchar *db_name);
extern void gpilotd_conduit_end(const gchar *id,
				const gchar *conduit_name);
extern void gpilotd_conduit_progress(const gchar *id,
				     const gchar *conduit,
				     long current, 
				     long total);
extern void gpilotd_conduit_message(const gchar *id, 
				    const gchar *conduit,
				    const gchar *message);
extern void gpilotd_conduit_error(const gchar *id, 
				  const gchar *conduit,
				  const gchar *message);

/* service calls */

gint gpilotd_init(int *argc,char *argv[]);
gint gpilotd_connect(void);
void gpilotd_shutdown(void);

gint gpilotd_monitor_on(gchar *pilot_id);
gint gpilotd_monitor_off(gchar *pilot_id);
gint gpilotd_notify_on(GNOME_Pilot_EventType type);
gint gpilotd_notify_off(GNOME_Pilot_EventType type);

gint gpilotd_restore(gchar *pilot_id,
		     gchar *directory,
		     GNOME_Pilot_Survival survival,
		     int timeout);

gint gpilotd_install_file(gchar *pilot_id,
			  gchar *name,
			  GNOME_Pilot_Survival survival,
			  int timeout);

gint gpilotd_set_user_info(gchar *cradle,
			   GNOME_Pilot_PilotUser user,
			   GNOME_Pilot_Survival survival,
			   int timeout);

gint gpilotd_get_user_info(gchar *cradle,
			   GNOME_Pilot_Survival survival,
			   int timeout);

gint gpilotd_get_system_info(gchar *cradle,
			     GNOME_Pilot_Survival survival,
			     int timeout);

gint gpilotd_remove_request(gint handle);

gint gpilotd_conduit(gchar *pilot,
		     gchar *conduit,
		     GNOME_Pilot_ConduitOperation operation,
		     GNOME_Pilot_Survival survival, 
		     int timeout);

  /* get_* calls 
     Return value is 0 for success, negative for failure.
     Argument lists are NULL (for gchar**) or -1 (gint*) terminated.
   */

int gpilotd_get_users(gchar***);
int gpilotd_get_conduits(gchar***);
int gpilotd_get_cradles(gchar***);
int gpilotd_get_pilot_names(gchar***);
int gpilotd_get_pilot_ids(gint**);
int gpilotd_get_pilots_by_name(gchar *name,gchar***);
int gpilotd_get_pilots_by_login(gchar *login,gchar***);

/**
   Enable monitoring for all available pilots
*/
void gpilotd_monitor_on_all_pilots(void);

/**
   Disable monitoring for all pilots.
*/
void gpilotd_monitor_off_all_pilots(void);

/*
  Misc info functions
*/
	
/* returns a string with the given pilots base dir. Returned pointer
   must be freed by caller */
gchar* gpilotd_get_pilot_basedir(gchar *pilot);
gchar* gpilotd_get_pilot_basedir_by_id(guint32 id);
gchar* gpilotd_get_name_from_id(guint32 id); /* return val must be freed */
guint32 gpilotd_get_id_from_name(gchar *name);

#ifdef __cplusplus
} 
#endif /*__cplusplus */

#endif /* __GPILOTD_APP_H */
