#include <glib.h>
#include <gnome.h>
#include <pwd.h>
#include <sys/types.h>
#include "gpilot-userinfo.h"
#include "gnome-pilot-conduit.h"
#include "manager.h"

GPilotPilot *
gpilot_pilot_new (void)
{
	GPilotPilot *retval;

	retval = (GPilotPilot *)g_malloc(sizeof(GPilotPilot));
	if (!retval)
		return NULL;
	retval->name = NULL;
	retval->passwd = NULL;
	retval->number = 0;
	retval->pilot_username = NULL;
	retval->pilot_id = 0;
	retval->trusted_users = NULL;
	retval->sync_options.default_sync_action = 0;
	retval->sync_options.basedir = NULL;
  
	return retval;
}

void
gpilot_pilot_init (GPilotPilot *pilot, 
		   gint i)
{
	gchar *tmp_str;
	gchar *prefix;

	/* set up stuff  */
	g_free (pilot->name);
	g_free (pilot->passwd);
	g_free (pilot->pilot_username);
	g_list_foreach (pilot->trusted_users, (GFunc) g_free, NULL);
	g_list_free (pilot->trusted_users);
	prefix = g_strdup_printf ("/gnome-pilot.d/gpilotd/Pilot%d/", i);
	gnome_config_push_prefix (prefix);

	/* start filling in fields */
	pilot->name = gnome_config_get_string("name");
	pilot->pilot_id = gnome_config_get_int("pilotid");
	pilot->pilot_username = gnome_config_get_string("pilotusername");
	pilot->passwd = gnome_config_get_string("password");
	pilot->number=i;
	pilot->trusted_users=NULL;
	tmp_str = gnome_config_get_string("default_sync_action=synchronize");
	pilot->sync_options.default_sync_action = gnome_pilot_conduit_sync_type_str_to_int(tmp_str);
	g_free (tmp_str);
	pilot->sync_options.basedir = gnome_config_get_string("basedir");

	gnome_config_pop_prefix ();
	g_free(prefix);
}

void
gpilot_pilot_free (GPilotPilot *pilot)
{
	g_free (pilot->name);
	g_free (pilot->passwd);
	g_free (pilot->pilot_username);
	g_free (pilot->sync_options.basedir);
	g_list_foreach (pilot->trusted_users, (GFunc) g_free, NULL);
	g_list_free (pilot->trusted_users);
	g_free (pilot);
}

GPilotUser *
gpilot_user_new (void) {
	GPilotUser *retval;

	retval = (GPilotUser *)g_malloc(sizeof(GPilotUser));
	retval->username = NULL;

	return retval;
}

void
gpilot_user_free (GPilotUser *user)
{
	g_free (user->username);
	g_free (user);
}
 
GPilotPilot*
gpilot_find_pilot_by_name(gchar *id,GList *inlist) 
{
	GList *iterator;
	iterator = inlist;
	while(iterator!=NULL) {
		GPilotPilot *retval;
		retval = GPILOT_PILOT(iterator->data);
		if (strcmp(retval->name,id)==0) return retval;
		iterator = iterator->next;
	}
	return NULL;
}

GPilotPilot*
gpilot_find_pilot_by_id(guint32 id,GList *inlist) 
{
	GList *iterator;
	iterator = inlist;
	while(iterator!=NULL) {
		GPilotPilot *retval;
		retval = GPILOT_PILOT(iterator->data);
		if (retval->pilot_id ==id) return retval;
		iterator = iterator->next;
	}
	return NULL;
}
