 /* gnome-pilot-conduit.c
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "gnome-pilot-conduit.h"
#include "gnome-pilot-conduit-standard.h"

enum {
	COPY_TO_PILOT,
	COPY_FROM_PILOT,
	MERGE_TO_PILOT,
	MERGE_FROM_PILOT,
	SYNCHRONIZE,
	LAST_SIGNAL
};

static void gnome_pilot_conduit_standard_init			(GnomePilotConduitStandard *conduit);
static void gnome_pilot_conduit_standard_class_init		(GnomePilotConduitStandardClass
								                   *klass);
static void gnome_pilot_conduit_standard_finalize		(GtkObject         *object);
static gint gnome_real_pilot_conduit_standard_copy_to_pilot	(GnomePilotConduitStandard *conduit,
								 GnomePilotDBInfo  *dbinfo);
static gint gnome_real_pilot_conduit_standard_merge_to_pilot	(GnomePilotConduitStandard *conduit,
								 GnomePilotDBInfo  *dbinfo);
static gint gnome_real_pilot_conduit_standard_merge_from_pilot	(GnomePilotConduitStandard *conduit,
								 GnomePilotDBInfo  *dbinfo);
static gint gnome_real_pilot_conduit_standard_synchronize	(GnomePilotConduitStandard *conduit,
								 GnomePilotDBInfo  *dbinfo);


static GnomePilotConduitClass *parent_class = NULL;
static guint pilot_conduit_standard_signals[LAST_SIGNAL] = { 0 };


GtkType
gnome_pilot_conduit_standard_get_type (void)
{
	static GtkType pilot_conduit_standard_type = 0;

	if (!pilot_conduit_standard_type)
	{
		static const GtkTypeInfo pilot_conduit_standard_info =
		{
			"GnomePilotConduitStandard",
			sizeof (GnomePilotConduitStandard),
			sizeof (GnomePilotConduitStandardClass),
			(GtkClassInitFunc) gnome_pilot_conduit_standard_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_standard_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		pilot_conduit_standard_type = gtk_type_unique (gnome_pilot_conduit_get_type (),
							       &pilot_conduit_standard_info);
	}

	return pilot_conduit_standard_type;
}

static void
gnome_pilot_conduit_standard_class_init (GnomePilotConduitStandardClass *klass)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class (gnome_pilot_conduit_get_type ());

	pilot_conduit_standard_signals[COPY_TO_PILOT] =
		gtk_signal_new ("copy_to_pilot",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitStandardClass, copy_to_pilot),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1, GTK_TYPE_POINTER);
	pilot_conduit_standard_signals[COPY_FROM_PILOT] =
		gtk_signal_new ("copy_from_pilot",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitStandardClass, copy_from_pilot),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1, GTK_TYPE_POINTER);
	pilot_conduit_standard_signals[MERGE_TO_PILOT] =
		gtk_signal_new ("merge_to_pilot",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitStandardClass, merge_to_pilot),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1, GTK_TYPE_POINTER);
	pilot_conduit_standard_signals[MERGE_FROM_PILOT] =
		gtk_signal_new ("merge_from_pilot",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitStandardClass, merge_from_pilot),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1, GTK_TYPE_POINTER);
	pilot_conduit_standard_signals[SYNCHRONIZE] =
		gtk_signal_new ("synchronize",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitStandardClass, synchronize),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1, GTK_TYPE_POINTER);


	gtk_object_class_add_signals (object_class, pilot_conduit_standard_signals, LAST_SIGNAL);

	object_class->finalize = gnome_pilot_conduit_standard_finalize;

	klass->copy_to_pilot = gnome_real_pilot_conduit_standard_copy_to_pilot;
	klass->merge_to_pilot = gnome_real_pilot_conduit_standard_merge_to_pilot;
	klass->merge_from_pilot = gnome_real_pilot_conduit_standard_merge_from_pilot;
	klass->synchronize = gnome_real_pilot_conduit_standard_synchronize;
}

static void
gnome_pilot_conduit_standard_init (GnomePilotConduitStandard *conduit)
{
	conduit->slow = FALSE;
	conduit->db_name = NULL;
}


static void
gnome_pilot_conduit_standard_finalize (GtkObject *object)
{
	GnomePilotConduitStandard *conduit;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (object));

	conduit = GNOME_PILOT_CONDUIT_STANDARD (object);

	g_free (conduit->db_name);

	GTK_OBJECT_CLASS (parent_class)->finalize (object);
}

static gint
gnome_real_pilot_conduit_standard_copy_to_pilot (GnomePilotConduitStandard *conduit,
						 GnomePilotDBInfo  *dbinfo)
{
	g_return_val_if_fail (conduit != NULL, 0);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), 0);

	return 0;
}
static gint
gnome_real_pilot_conduit_standard_merge_to_pilot (GnomePilotConduitStandard *conduit,
						  GnomePilotDBInfo  *dbinfo)
{
	g_return_val_if_fail (conduit != NULL, 0);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), 0);

	return 0;
}
static gint
gnome_real_pilot_conduit_standard_merge_from_pilot (GnomePilotConduitStandard *conduit,
						    GnomePilotDBInfo  *dbinfo)
{
	g_return_val_if_fail (conduit != NULL, 0);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), 0);

	return 0;
}
static gint
gnome_real_pilot_conduit_standard_synchronize (GnomePilotConduitStandard *conduit,
					       GnomePilotDBInfo  *dbinfo)
{
	g_return_val_if_fail (conduit != NULL, 0);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), 0);

	return 0;
}

/* Public Functions. */
GtkObject  *
gnome_pilot_conduit_standard_new (const char *db_name,
				  guint32 creator_id)
{
	GtkObject *retval;
	retval = GTK_OBJECT (gtk_type_new (gnome_pilot_conduit_standard_get_type ()));

	gnome_pilot_conduit_standard_construct (GNOME_PILOT_CONDUIT_STANDARD (retval),
						db_name,
						creator_id);
	return retval;
}
void
gnome_pilot_conduit_standard_construct (GnomePilotConduitStandard *conduit,
					const char *db_name,
					guint32 creator_id)
{
	g_return_if_fail (conduit != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit));

	conduit->db_name = g_strdup (db_name);
	conduit->creator_id = creator_id;
}
const char *
gnome_pilot_conduit_standard_get_db_name (GnomePilotConduitStandard *conduit)
{
	g_return_val_if_fail (conduit != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), NULL);

	return (const gchar *)conduit->db_name;
}
guint32
gnome_pilot_conduit_standard_get_creator_id (GnomePilotConduitStandard *conduit)
{
	g_return_val_if_fail (conduit != NULL, 0);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), 0);

	return conduit->creator_id;
}

void
gnome_pilot_conduit_standard_set_slow(GnomePilotConduitStandard *conduit) {
	g_return_if_fail (conduit != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit));
	conduit->slow = TRUE;
}

gint
gnome_pilot_conduit_standard_copy_to_pilot (GnomePilotConduitStandard *conduit,
					    GnomePilotDBInfo  *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), -1);

	gtk_signal_emit (GTK_OBJECT (conduit), pilot_conduit_standard_signals[COPY_TO_PILOT], dbinfo, &retval);
	return retval;
}
gint
gnome_pilot_conduit_standard_copy_from_pilot (GnomePilotConduitStandard *conduit,
					      GnomePilotDBInfo  *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), -1);

	gtk_signal_emit (GTK_OBJECT (conduit), pilot_conduit_standard_signals[COPY_FROM_PILOT], dbinfo, &retval);
	return retval;
}
gint
gnome_pilot_conduit_standard_merge_to_pilot (GnomePilotConduitStandard *conduit,
					     GnomePilotDBInfo  *dbinfo)

{
	gint retval = 0;
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), -1);

	gtk_signal_emit (GTK_OBJECT (conduit), pilot_conduit_standard_signals[MERGE_TO_PILOT], dbinfo, &retval);
	return retval;
}
gint
gnome_pilot_conduit_standard_merge_from_pilot (GnomePilotConduitStandard *conduit,
					       GnomePilotDBInfo  *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), -1);

	gtk_signal_emit (GTK_OBJECT (conduit), pilot_conduit_standard_signals[MERGE_FROM_PILOT], dbinfo, &retval);
	return retval;
}
gint
gnome_pilot_conduit_standard_synchronize (GnomePilotConduitStandard *conduit,
					  GnomePilotDBInfo  *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_STANDARD (conduit), -1);

	gtk_signal_emit (GTK_OBJECT (conduit), pilot_conduit_standard_signals[SYNCHRONIZE], dbinfo, &retval);
	return retval;
}
