/* gnome-pilot-conduit-backup.c
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "gnome-pilot-conduit-backup.h"
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <utime.h>
#include <pi-file.h>

enum {
	BACKUP_DB,
	BACKUP_PRC,
	BACKUP,
	LAST_SIGNAL
};

static void gnome_pilot_conduit_backup_init		(GnomePilotConduitBackup		 *pilot_conduit_backup);
static void gnome_pilot_conduit_backup_class_init	(GnomePilotConduitBackupClass	 *klass);
static gint gnome_real_pilot_conduit_backup_backup_db	(GnomePilotConduitBackup		 *pilot_conduit_backup,
							 GnomePilotDBInfo *dbinfo);
static gint gnome_real_pilot_conduit_backup_backup_prc	(GnomePilotConduitBackup		 *pilot_conduit_backup,
							 GnomePilotDBInfo *dbinfo);
static gint gnome_real_pilot_conduit_backup_backup	(GnomePilotConduitBackup		 *pilot_conduit_backup,
							 GnomePilotDBInfo *dbinfo);
static void gnome_pilot_conduit_backup_finalize        	(GtkObject *object);

static GnomePilotConduitClass *parent_class = NULL;
static guint pilot_conduit_backup_signals[LAST_SIGNAL] = { 0 };


GtkType
gnome_pilot_conduit_backup_get_type (void)
{
	static GtkType pilot_conduit_backup_type = 0;

	if (!pilot_conduit_backup_type)
	{
		static const GtkTypeInfo pilot_conduit_backup_info =
		{
			"GnomePilotConduitBackup",
			sizeof (GnomePilotConduitBackup),
			sizeof (GnomePilotConduitBackupClass),
			(GtkClassInitFunc) gnome_pilot_conduit_backup_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_backup_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		pilot_conduit_backup_type = gtk_type_unique (gnome_pilot_conduit_get_type (), &pilot_conduit_backup_info);
	}

	return pilot_conduit_backup_type;
}

static void
gnome_pilot_conduit_backup_class_init (GnomePilotConduitBackupClass *klass)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class (gnome_pilot_conduit_get_type ());

	pilot_conduit_backup_signals[BACKUP_DB] =
		gtk_signal_new ("backup_db",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitBackupClass, backup_db),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1,
				GTK_TYPE_POINTER);
	pilot_conduit_backup_signals[BACKUP_PRC] =
		gtk_signal_new ("backup_prc",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitBackupClass, backup_prc),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1,
				GTK_TYPE_POINTER);
	pilot_conduit_backup_signals[BACKUP] =
		gtk_signal_new ("backup",
				GTK_RUN_LAST,
				object_class->type,
				GTK_SIGNAL_OFFSET (GnomePilotConduitBackupClass, backup),
				gtk_marshal_INT__POINTER,
				GTK_TYPE_INT, 1,
				GTK_TYPE_POINTER);


	gtk_object_class_add_signals (object_class, pilot_conduit_backup_signals, LAST_SIGNAL);


	object_class->finalize = gnome_pilot_conduit_backup_finalize;
	klass->backup_db = gnome_real_pilot_conduit_backup_backup_db;
	klass->backup_prc = gnome_real_pilot_conduit_backup_backup_prc;
	klass->backup = gnome_real_pilot_conduit_backup_backup;
}


static void
gnome_pilot_conduit_backup_init (GnomePilotConduitBackup *pilot_conduit_backup)
{
	GNOME_PILOT_CONDUIT (pilot_conduit_backup)->name = g_strdup ("backup");
}


static gint
gnome_real_pilot_conduit_backup_backup (GnomePilotConduitBackup *pilot_conduit_backup,
					   GnomePilotDBInfo *dbinfo)
{
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	return 0;
}
static gint
gnome_real_pilot_conduit_backup_backup_db (GnomePilotConduitBackup *pilot_conduit_backup,
					   GnomePilotDBInfo *dbinfo)
{
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	return 0;
}
static gint
gnome_real_pilot_conduit_backup_backup_prc (GnomePilotConduitBackup *pilot_conduit_backup,
					    GnomePilotDBInfo *dbinfo)
{
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	return 0;
}
static void
gnome_pilot_conduit_backup_finalize (GtkObject *object)
{
	GnomePilotConduitBackup *conduit;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (object));

	conduit = GNOME_PILOT_CONDUIT_BACKUP (object);

	GTK_OBJECT_CLASS (parent_class)->finalize (object);
}

/* Public Functions */
GtkObject *
gnome_pilot_conduit_backup_new (void)
{
	return GTK_OBJECT (gtk_type_new (gnome_pilot_conduit_backup_get_type ()));
}
void
gnome_pilot_conduit_backup_construct  (GnomePilotConduitBackup *pilot_conduit_backup,
				       gchar *backup_dir,
				       gboolean remove_deleted,
				       gboolean updated_only,
				       guint32 pilotId)
{
	g_return_if_fail (pilot_conduit_backup != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup));

	gnome_pilot_conduit_construct (GNOME_PILOT_CONDUIT (pilot_conduit_backup),
				       "backup");
}

gint
gnome_pilot_conduit_backup_backup_db  (GnomePilotConduitBackup *pilot_conduit_backup,
				       GnomePilotDBInfo *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	gtk_signal_emit (GTK_OBJECT (pilot_conduit_backup), pilot_conduit_backup_signals[BACKUP_DB], dbinfo, &retval);
	return retval;
}

gint
gnome_pilot_conduit_backup_backup_prc (GnomePilotConduitBackup *pilot_conduit_backup,
				       GnomePilotDBInfo *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	gtk_signal_emit (GTK_OBJECT (pilot_conduit_backup), pilot_conduit_backup_signals[BACKUP_PRC], dbinfo, &retval);
	return retval;
}

gint
gnome_pilot_conduit_backup_backup     (GnomePilotConduitBackup *pilot_conduit_backup,
				       GnomePilotDBInfo *dbinfo)
{
	gint retval = 0;
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	gtk_signal_emit (GTK_OBJECT (pilot_conduit_backup), pilot_conduit_backup_signals[BACKUP], dbinfo, &retval);
	return retval;
}
