/* $Id: file_conduit.h,v 1.7 1999/10/22 00:23:07 eskil Exp $ */

typedef struct ConduitCfg {
  guint32 pilotId;
  pid_t child;
} ConduitCfg;

typedef struct db {
        char name[256];
        int flags;
        unsigned long creator;
        unsigned long type;
        int maxblock;
} db;

#define CONDUIT_CFG(s) ((ConduitCfg*)(s))
#undef DEBUG
static void 
load_configuration(ConduitCfg **c,
		   guint32 pilotId) 
{
	g_assert(c!=NULL);
	*c = g_new0(ConduitCfg,1);
	(*c)->pilotId = pilotId;
}

static void 
save_configuration(ConduitCfg *c) 
{
	g_return_if_fail(c!=NULL);
}

static ConduitCfg*
dupe_configuration(ConduitCfg *c) {
	ConduitCfg *retval;
	g_return_val_if_fail(c!=NULL,NULL);
	retval = g_new0(ConduitCfg,1);
	retval->pilotId = c->pilotId;
	return retval;
}

/** this method frees all data from the conduit config */
static void 
destroy_configuration(ConduitCfg **c) 
{
	g_return_if_fail(c!=NULL);
	g_return_if_fail(*c!=NULL);
	g_free(*c);
	*c = NULL;
}

