#include <gpilotd/gpilotd-app.h>
#include <libgnorba/gnorba.h>
CORBA_Environment ev;

void gpilotd_connect_cb(const gchar *id,const GNOME_Pilot_PilotUser *user) {
  g_message("connect");
}

void gpilotd_disconnect_cb(const gchar *id) {
  g_message("disconnect");
}

void gpilotd_request_completed(const gchar *id,unsigned long handle) {
}

void gpilotd_userinfo_requested(const gchar *device,const  GNOME_Pilot_PilotUser *user) {
  g_message("pilot in cradle %s is owned by %d:%s",device,user->userID,user->username);
}


void gpilotd_conduit_start(const gchar *id, 
			   const gchar *conduit_name, 
			   const gchar *db_name) { 
	g_message("conduit_start(%s,%s,%s)",id,conduit_name,db_name);
}

void gpilotd_conduit_end(const gchar *id) { 
	g_message("conduit_end(%s)",id);
}

void gpilotd_sysinfo_requested(const gchar *id,const  GNOME_Pilot_SysInfo *info) {
  g_message("pilot %s",id);
  g_message("  ROMSIZE = %lu",info->romSize);
  g_message("  RAMSIZE = %lu",info->ramSize);
  g_message("  RAMFREE = %lu",info->ramFree);
}

int main(int argc,char *argv[]) {

  if(argc<2) {
    g_message("usage : test_client command [options]");
    g_message("        command: install pilot file");
    g_message("        command: getinfo cradle");
    g_message("        command: getsysinfo");
    g_message("        command: setinfo cradle name id");
    g_message("        command: getusers");
    g_message("        command: getcradles");
    g_message("        command: getpilots");
    g_message("        command: getpilotids");
    g_message("        command: getconduits");
    g_message("        command: conduit name");
    g_message("        command: pilotsbyname name");
    g_message("        command: pilotsbyuid name");
    exit(1);
  }

  gnome_CORBA_init("fisk","1.0",&argc,argv,0,&ev);

  /* 1. initialize the gpilotd connection */
  if(gpilotd_init(&argc,argv)!=0) g_error("Cannot connect to gpilotd");
  /* 1.1 connect to gpilotd */
  if(gpilotd_connect()!=0) g_error("Cannot connect to gpilotd");
  /* 2. specify pilots to monitor */
  gpilotd_monitor_on_all_pilots();
  /* 3. specify events to monitor */
  gpilotd_notify_on(GNOME_Pilot_NOTIFY_CONNECT);
  gpilotd_notify_on(GNOME_Pilot_NOTIFY_DISCONNECT);

  /* behold the ugly cli parsing... */
  if(strcmp(argv[1],"install")==0) {
    if(argc==4) {
      int handle;
      handle = gpilotd_install_file(argv[2],argv[3],GNOME_Pilot_PERSISTENT,0);
      /*
	g_message("now deleting %d",handle);
	gpilotd_remove_request(handle);
      */
    } else 
      g_error("pilot and filename required");
  } else
    if(strcmp(argv[1],"getinfo")==0) {
      if(argc==3)
	gpilotd_get_user_info(argv[2],GNOME_Pilot_PERSISTENT,0);
      else 
	g_error("cradle required");
    } else
      if(strcmp(argv[1],"setinfo")==0) {
	if(argc==5) {
	  GNOME_Pilot_PilotUser user;
	  user.userID = atol(argv[4]);
	  user.username = argv[3];
	  gpilotd_set_user_info(argv[2],user,GNOME_Pilot_PERSISTENT,0);
	} else 
	  g_error("cradle name id required");
      } else
	if(strcmp(argv[1],"getusers")==0) {
	  gchar **users;
	  int i;
	  gpilotd_get_users(&users);
	  i=0;
	  if(users)
	    while(users[i]) { g_message("user %d = \"%s\"",i,users[i]); i++; }
	} else
	  if(strcmp(argv[1],"getcradles")==0) {
	    gchar **cradles;
	    int i;
	    gpilotd_get_cradles(&cradles);
	    i=0;
	    if(cradles)
	      while(cradles[i]) { g_message("cradle %d = \"%s\"",i,cradles[i]); i++; }
	  } else
	    if(strcmp(argv[1],"getpilotids")==0) {
	      gint *pilots;
	      int i;
	      gpilotd_get_pilot_ids(&pilots);
	      i=0;
	      if(pilots)
		while(pilots[i]!=-1) { g_message("pilot %d = %d",i,pilots[i]); i++; }
	    } else
	    if(strcmp(argv[1],"getpilots")==0) {
	      gchar **pilots;
	      int i;
	      gpilotd_get_pilot_names(&pilots);
	      i=0;
	      if(pilots)
		while(pilots[i]) { g_message("pilot %d = \"%s\"",i,pilots[i]); i++; }
	    } else
	      if(strcmp(argv[1],"getconduits")==0) {
		gchar **conduits;
		int i;
		gpilotd_get_conduits(&conduits);
		i=0;
		if(conduits)
		  while(conduits[i]) { g_message("conduit %d = \"%s\"",i,conduits[i]); i++; }
	      } else if(strcmp(argv[1],"getsysinfo")==0) {
		gint ret;
		ret = gpilotd_get_system_info("p3",GNOME_Pilot_PERSISTENT,0);
		sleep(6);
		gpilotd_remove_request(ret);
	      } else if(strcmp(argv[1],"term")==0) {
		gpilotd_monitor_off_all_pilots();
		return 0;
	      } else if(strcmp(argv[1],"conduit")==0) {
		guint32 handle;
		handle = gpilotd_conduit(argv[2],argv[3],
					 GNOME_Pilot_CONDUIT_DEFAULT,
					 GNOME_Pilot_PERSISTENT,0);
		//g_message("now deleting %u",handle);
		//gpilotd_remove_request(handle);

	      } else if(strcmp(argv[1],"pilotsbyname")==0) {
		gchar **pilots;
		int i;
		gpilotd_get_pilots_by_name(argv[2],&pilots);
		i=0;
		if(pilots)
		  while(pilots[i]) { g_message("pilot %d = \"%s\"",i,pilots[i]); i++; }
	      } else if(strcmp(argv[1],"pilotsbyuid")==0) {
		gchar **pilots;
		int i;
		gpilotd_get_pilots_by_login(argv[2],&pilots);
		i=0;
		if(pilots)
		  while(pilots[i]) { g_message("pilot %d = \"%s\"",i,pilots[i]); i++; }
	      }


  /*g_main_run(g_main_new(FALSE));*/
  while(1) { giop_main_iterate(0); };

  gpilotd_shutdown();
  CORBA_ORB_shutdown(gnome_CORBA_ORB(), CORBA_FALSE, &ev);

  return 0;
}

