#ifndef __GPILOTD_QUEUE_IO__
#define __GPILOTD_QUEUE_IO__

#include <glib.h>
#include "gnome-pilot-conduit.h"
/* 
   new request types require additions to 
   load_requests, 
   store_request,
   request_type_from_string
   gpc_purge_requests
   gpc_queue_load_requests

   if system level request
   gpilotd.c:do_cradle_events
   is_system_related
   */

typedef enum {
  /* these are stored as [<pilotid>-<sequence>] */
  GREQ_PILOT_EVENT,
  GREQ_INSTALL,
  GREQ_RESTORE,
  GREQ_CONDUIT,
  GREQ_GET_SYSINFO,

  /* these are stored as [</dev/bla>-<sequence>] */
  GREQ_CRADLE_EVENT,
  GREQ_GET_USERINFO,
  GREQ_SET_USERINFO,
  GREQ_NEW_USERINFO,

  GREQ_INVALID=-1,
} GPilotRequestType;

typedef struct GPilotRequest {
	GPilotRequestType type;  /* identifies the request type */
	guint32 pilot_id;        /* identifies the pilot */
	guint32 handle;          /* this is set by gpc_queue_store_request */
	guint timeout;           /* zero for no timeout */
	gchar *device_name;      /* NULL unless event is cradle specific (SET\GET userinfo) */
	gchar *client_id;        /* identifying id, eg. IOR */
	
	/* these are the parameters for the requests, read as you wish */
	union parameters {
		struct {
			gchar *filename;
			gchar *description;
		} install;
		struct {
			gchar *directory;
		} restore;
		struct {
			gchar *name;
			GnomePilotConduitSyncType how;
		} conduit;
		struct {
			gchar *password;
			gchar *user_id;
			guint32 pilot_id;
		} set_userinfo;
		struct {
		} get_userinfo;
		struct {
		} get_sysinfo;
	} parameters;
	
	/* this is data for the queue management, don't use! */
	struct {
		gchar *section_name;
	} queue_data;
} GPilotRequest;

/* load requests from stored files */
GList* gpc_queue_load_requests(guint32 pilot_id,
			       GPilotRequestType type,
			       gboolean all); 
GPilotRequest* gpc_queue_load_request(guint32 pilot_id,
				      gboolean system,
				      guint num);

GList* gpc_queue_load_requests_for_cradle(gchar *cradle);

/* store a request in .gnome/gnome-pilot.d/queues/PILOT_ID */
guint gpc_queue_store_request(GPilotRequest req);

/* mark a request as processed, and purge from the queue files.
   This call also frees the data associated with the request.
 */
void gpc_queue_purge_request(GPilotRequest **req);
void gpc_queue_purge_request_point(guint32 pilot_id,guint num);

/* returns next time for request timeout (in secs) */


#endif

