/* gnome-pilot-conduit-standard-abs.h
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_PILOT_CONDUIT_STANDARD_ABS_H__
#define __GNOME_PILOT_CONDUIT_STANDARD_ABS_H__

#include <gnome.h>
#include "gnome-pilot-conduit-standard.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PILOT_CONDUIT_STANDARD_ABS			(gnome_pilot_conduit_standard_abs_get_type ())
#define GNOME_PILOT_CONDUIT_STANDARD_ABS(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD_ABS, GnomePilotConduitStandardAbs))
#define GNOME_PILOT_CONDUIT_STANDARD_ABS_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PILOT_CONDUIT_STANDARD_ABS, GnomePilotConduitStandardAbsClass))
#define GNOME_IS_PILOT_CONDUIT_STANDARD_ABS(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD_ABS))
#define GNOME_IS_PILOT_CONDUIT_STANDARD_ABS_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD_ABS))

enum
{
	GnomePilotRecordNothing,
	GnomePilotRecordNew,
	GnomePilotRecordDeleted,
	GnomePilotRecordModified,
	GnomePilotRecordPending
};

typedef struct _PilotRecord PilotRecord;
struct _PilotRecord {
	recordid_t ID;
	int attr;
	int archived;
	int secret;
	int length;
	int category;
	unsigned char * record;
};

typedef struct _LocalRecord LocalRecord;
struct _LocalRecord {
	int attr;
	int archived;
	int secret;
	recordid_t ID;
};

typedef struct _GnomePilotConduitStandardAbs       GnomePilotConduitStandardAbs;
typedef struct _GnomePilotConduitStandardAbsClass  GnomePilotConduitStandardAbsClass;

struct _GnomePilotConduitStandardAbs
{
	GnomePilotConduitStandard parent;

	/* Private data */
	GSList *recordIdsToIgnore; /* these are records added to the pilot during sync,
				      which sync_record should ignore */
	gint totalRecords; /* this is the total number of records to be traversed 
			      depending on the sync, used for progress bars
			    */
};
struct _GnomePilotConduitStandardAbsClass
{
	GnomePilotConduitStandardClass parent_class;

	/* Signals go here */
	int (*match_record)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord **local,
				 PilotRecord *remote);
	int (*free_match)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord **local);
	int (*archive_local)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local);
	int (*archive_remote)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 PilotRecord *remote);
	int (*store_remote)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 PilotRecord *remote);
	int (*clear_status_archive_local)
				(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local);
	int (*iterate)		(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord **local);
	int (*iterate_specific)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord **local,
				 gint flag,
				 gint archived);
	int (*purge)		(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs);
	int (*set_status)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 gint status);
	int (*set_archived)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 gint archived);
	int (*set_pilot_id)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 guint32 ID);
	int (*compare)		(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 PilotRecord *remote);
	int (*compare_backup)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 PilotRecord *remote);
	int (*free_transmit)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 PilotRecord **remote);
	int (*delete_all)	(GnomePilotConduitStandardAbs *pilot_conduit_standard_abs);
	int (*transmit)         (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 LocalRecord *local,
				 PilotRecord **);
	int (*pre_sync)         (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
				 GnomePilotDBInfo  *dbinfo);
};

GtkType    gnome_pilot_conduit_standard_abs_get_type (void);
GtkObject *gnome_pilot_conduit_standard_abs_new (const char *db_name,
						 guint32 creator_id);
gint gnome_pilot_conduit_standard_abs_match_record (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						    LocalRecord **local,
						    PilotRecord *remote);
gint gnome_pilot_conduit_standard_abs_free_match (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						  LocalRecord **local);
gint gnome_pilot_conduit_standard_abs_archive_local (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						     LocalRecord *local);
gint gnome_pilot_conduit_standard_abs_archive_remote (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						      LocalRecord *local,
						      PilotRecord *remote);
gint gnome_pilot_conduit_standard_abs_store_remote (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						    PilotRecord *remote);
gint gnome_pilot_conduit_standard_abs_clear_status_archive_local (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
								  LocalRecord *local);
gint gnome_pilot_conduit_standard_abs_iterate (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
					       LocalRecord **local);
gint gnome_pilot_conduit_standard_abs_iterate_specific (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
							LocalRecord **local,
							gint flag,
							gint archived);
gint gnome_pilot_conduit_standard_abs_purge (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs);
gint gnome_pilot_conduit_standard_abs_set_status (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						  LocalRecord *local,
						  gint status);
gint gnome_pilot_conduit_standard_abs_set_archived (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						    LocalRecord *local,
						    gint archived);
gint gnome_pilot_conduit_standard_abs_set_pilot_id (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						    LocalRecord *local,
						    guint32 id);
gint gnome_pilot_conduit_standard_abs_compare (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						      LocalRecord *local,
						      PilotRecord *remote);
gint gnome_pilot_conduit_standard_abs_compare_backup (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						      LocalRecord *local,
						      PilotRecord *remote);
gint gnome_pilot_conduit_standard_abs_free_transmit (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						      LocalRecord *local,
						      PilotRecord **remote);
gint gnome_pilot_conduit_standard_abs_delete_all (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs);
gint gnome_pilot_conduit_standard_abs_pre_sync   (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						  GnomePilotDBInfo  *dbinfo);
gint gnome_pilot_conduit_standard_abs_transmit (GnomePilotConduitStandardAbs *pilot_conduit_standard_abs,
						LocalRecord *local,
						PilotRecord **remote);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PILOT_CONDUIT_STANDARD_ABS_H__ */
