#include <gpilotd/gpilotd-app.h>
#include <libgnorba/gnorba.h>

CORBA_Environment ev;
GSList *handles;
GSList *failed,*notfailed;
int handle;
GtkWidget *dialog;


int now = 0, later = 0;
char *debug_modules = NULL;
static const struct poptOption options[] = {
	{"now", 'n', POPT_ARG_NONE, &now, 0, N_("Install immediately"), NULL},
	{"later", 'l', POPT_ARG_NONE, &later, 0, N_("Install delayed"), NULL},
	{NULL, '\0', 0, NULL, 0} /* end the list */
};

void 
gpilotd_connect_cb(const gchar *id,const GNOME_Pilot_PilotUser *user) 
{
}

void 
gpilotd_disconnect_cb(const gchar *id) 
{
}

void 
gpilotd_request_completed(const gchar *id,unsigned long handle) 
{
	g_message("%s completed %d",id,handle);
	handles = g_slist_remove(handles,(gpointer)handle);
	if (handles == NULL)
		gnome_dialog_close(GNOME_DIALOG(dialog));
}

void 
gpilotd_userinfo_requested(const gchar *device,const  GNOME_Pilot_PilotUser *user) 
{
}

void 
gpilotd_sysinfo_requested(const gchar *id,const  GNOME_Pilot_SysInfo *info) 
{
}

void gpilotd_conduit_start(const gchar *id, 
			   const gchar *conduit_name, 
			   const gchar *db_name) { 
	g_message("conduit_start(%s,%s,%s)",id,conduit_name,db_name);
}

void gpilotd_conduit_end(const gchar *id) { 
	g_message("conduit_end(%s)",id);
}

static void 
cancel_install(GnomeDialog *w,GSList *list) 
{
	GSList *e;

	for(e=list;e;e = g_slist_next(e)) {
		gpilotd_remove_request((gint)e->data);  
	}
	g_slist_free(list);

}

void 
show_warning_dialog(gchar *mesg,...) 
{
	char *tmp;
	va_list ap;
	va_start(ap,mesg);

	tmp = g_strdup_vprintf(mesg,ap);
	dialog = gnome_message_box_new(tmp,GNOME_MESSAGE_BOX_WARNING,
				       GNOME_STOCK_BUTTON_OK,NULL);
	gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
	g_free(tmp);
	va_end(ap);
}

int 
main(int argc,char *argv[]) 
{
	int err,i;
	GNOME_Pilot_Survival survive;
        poptContext pctx;
	gchar **pilots = NULL;
        char **args;
        
	if(argc<2) {
		g_message("usage : %s [--now|--later] [FILE]",argv[0]);
		exit(1);
	}
	
	gnome_CORBA_init_with_popt_table("gpilotd-install-file","1.0",
					 &argc,argv,
					 options,0,&pctx,
					 0,&ev);

	/* 1. initialize the gpilotd connection */
	if (gpilotd_init(&argc,argv) != 0) {
		g_warning(_("Cannot start the GnomePilot daemon"));
		show_warning_dialog(_("Cannot start the GnomePilot daemon"));
		exit(1);
	}
	/* 1.1 connect to gpilotd */
	if (gpilotd_connect() != 0)  {
		g_warning(_("Cannot connect to the GnomePilot daemon"));
		show_warning_dialog(_("Cannot connect to the GnomePilot daemon"));
		exit(1);
	}
	
	err = gpilotd_get_pilot_names (&pilots);
	if (err != 0 || pilots == NULL) {
                g_warning (_("Unable to get pilot names"));
		show_warning_dialog(_("Unable to get pilot names"));
		exit(1);
        }

	notfailed = failed = handles = NULL;

	survive = GNOME_Pilot_IMMEDIATE;
	if (later) survive = GNOME_Pilot_PERSISTENT;
	
	i=0;

        args = poptGetArgs(pctx);

	while(args && args[i]!=NULL) {
		if (g_file_exists(args[i]) != 0) {
			handle = gpilotd_install_file(pilots[0],args[i],survive,0);
			if (handle > 0) {
				handles = g_slist_prepend(handles,(gpointer)handle);
				notfailed = g_slist_prepend(notfailed,args[i]);
			} else {
				failed = g_slist_prepend(failed,args[i]);
			}
		} else {
			failed = g_slist_prepend(failed,g_strdup(args[i]));
		}
		i++;
	}

        poptFreeContext(pctx);

	if (!later) {
		gchar *message;
		
		message = NULL;
		if (failed != NULL) {
			GSList *e;
			message = g_strdup(_("Following files failed :\n"));
			for (e=failed;e;e = g_slist_next(e)) {
				gchar *tmp;
				tmp = g_strconcat(message,"\t- ",e->data,"\n",NULL);
				g_free(message);
				message = tmp;
			}
			g_slist_free(failed);
		}
		{
			GSList *e;
			if (message == NULL)
				message = g_strdup(_("Installing :\n"));
			else {
				gchar *tmp;
				tmp = g_strconcat(message,"\nInstalling :\n",NULL);
				g_free(message);
				message = tmp;
			}
			for (e=notfailed;e;e = g_slist_next(e)) {
				gchar *tmp;
				tmp = g_strconcat(message,"\t- ",e->data,"\n",NULL);
				g_free(message);
				message = tmp;
			}
			g_slist_free(notfailed);
		}
		{
			gchar *tmp;
			gchar *info;

			if (handles == NULL) 
				info = g_strdup(_("No files to install"));
			else 
				info = g_strdup(_("Press synchronize on the cradle to install\n" 
						  " or cancel the operation."));
						
			tmp = g_strconcat(message==NULL?"":message,
					  "\n",
					  info,
					  NULL);
			g_free(message);
			g_free(info);
			message = tmp;
		}
		dialog = gnome_message_box_new(message,
					       GNOME_MESSAGE_BOX_GENERIC,
					       GNOME_STOCK_BUTTON_CANCEL,
					       NULL);
		gnome_dialog_button_connect(GNOME_DIALOG(dialog),0,
					    cancel_install,handles);
		gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
		g_free(message);
	}

	gpilotd_shutdown(); 
	CORBA_ORB_shutdown(gnome_CORBA_ORB(), CORBA_FALSE, &ev);

  return 0;
}

