/* $Id: email_conduit.h,v 1.8 1999/10/26 19:26:26 eskil Exp $ */

typedef struct ConduitCfg {
  gchar *sendmail;
  gchar *fromAddr;
  gchar *sendAction;
  gchar *mhDirectory;
  gchar *receiveAction;
  guint32 pilotId;
  pid_t child;
} ConduitCfg;

#define GET_CONFIG(c) ((ConduitCfg*)(gtk_object_get_data(GTK_OBJECT(c),"conduit_config")))
//#define EC_DEBUG
#ifdef EC_DEBUG
#define LOG(format,args...) g_log (G_LOG_DOMAIN, \
                                   G_LOG_LEVEL_MESSAGE, \
                                   "email: "##format, ##args)
#else
#define LOG(format,args...)
#endif


static void 
load_configuration(ConduitCfg **c,guint32 pilotId) 
{
	gchar *prefix;

	g_assert(c!=NULL);
	*c = g_new0(ConduitCfg,1);
	(*c)->child = -1;

	prefix = g_strdup_printf("/gnome-pilot.d/email-conduit/Pilot_%u/",pilotId);
  
	gnome_config_push_prefix(prefix);
	(*c)->sendmail = gnome_config_get_string( "sendmail=/usr/lib/sendmail -t -i");
	(*c)->fromAddr = gnome_config_get_string( "from_address" );
	(*c)->sendAction = gnome_config_get_string( "send_action=file");
	(*c)->mhDirectory = gnome_config_get_string( "mh_directory" );
	(*c)->receiveAction = gnome_config_get_string( "receive_action=file" );
	gnome_config_pop_prefix();

	(*c)->pilotId = pilotId;
	g_free(prefix);
}


static void 
save_configuration(ConduitCfg *c) 
{
	gchar *prefix;

	g_assert(c!=NULL);
	prefix = g_strdup_printf("/gnome-pilot.d/email-conduit/Pilot_%u/",c->pilotId);

#ifdef EC_DEBUG
	fprintf(stderr,"email_conduit: savecfg: prefix = %s\n",prefix);
#endif

	gnome_config_push_prefix(prefix);
	gnome_config_set_string("sendmail", c->sendmail);
	gnome_config_set_string("from_address", c->fromAddr);
	gnome_config_set_string("send_action", c->sendAction);
	gnome_config_set_string("mh_directory", c->mhDirectory);
	gnome_config_set_string("receive_action", c->receiveAction);
	gnome_config_pop_prefix();

	gnome_config_sync();
	gnome_config_drop_all();
	g_free(prefix);
}

static ConduitCfg*
dupe_configuration(ConduitCfg *c) {
	ConduitCfg *retval;
	g_assert(c!=NULL);
	retval = g_new0(ConduitCfg,1);
	retval->sendmail = g_strdup(c->sendmail);
	retval->fromAddr = g_strdup(c->fromAddr);
	retval->sendAction = g_strdup(c->sendAction);
	retval->mhDirectory = g_strdup(c->mhDirectory);
	retval->receiveAction = g_strdup(c->receiveAction);
	retval->pilotId = c->pilotId;
	return retval;
}

/** this method frees all data from the conduit config */
static void 
destroy_configuration(ConduitCfg **c) 
{
	g_assert(c!=NULL);
	g_assert(*c!=NULL);
	g_free( (*c)->sendmail );
	g_free( (*c)->fromAddr );
	g_free( (*c)->sendAction );
	g_free( (*c)->mhDirectory );
	g_free( (*c)->receiveAction );
	g_free(*c);
	*c = NULL;
}

