/* $Id: backup_conduit.h,v 1.15 1999/10/27 02:13:26 vadim Exp $ */
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

typedef struct ConduitCfg {
  gchar *backup_dir;
  GList *exclude_files;
  GList *files_in_backup;   /* contains the file in backup, any entries when
                               destroy is called are considered deleted on PDA */
  gboolean remove_deleted;
  gboolean updated_only;
  guint32 pilotId;
  pid_t child;
} ConduitCfg;

#define CONDUIT_CFG(s) ((ConduitCfg*)(s))
#define GET_CFG(s) ((ConduitCfg*)(gtk_object_get_data(GTK_OBJECT(s),"configuration")))
#define BC_DEBUG

void 
load_configuration(ConduitCfg **c,guint32 pilotId) 
{
	gchar *prefix;
	
	*c = g_new0(ConduitCfg,1);
	(*c)->child = -1;
	
	prefix = g_strdup_printf("/gnome-pilot.d/backup-conduit/Pilot_%u/",pilotId);
	
	gnome_config_push_prefix(prefix);
	(*c)->backup_dir = gnome_config_get_string("backup_dir");
	(*c)->updated_only = gnome_config_get_bool("updated_only=TRUE");
	(*c)->remove_deleted = gnome_config_get_bool("remove_deleted=FALSE");
	gnome_config_pop_prefix();
	
	(*c)->exclude_files = NULL;
	(*c)->files_in_backup = NULL;
	
	if((*c)->backup_dir==NULL) {
		(*c)->backup_dir = g_strdup_printf("%s/pilot/",g_get_home_dir());
	} 
	
	if(mkdir((*c)->backup_dir,(mode_t)0755) < 0) { /* Wow, I never though I would
							  use octal in C :) */
		if(errno != EEXIST) {
			/* YECH! 
			   CONDUIT_CFG(c.gpilotd_methods)->log_error("Cannot open whatever...");
			*/
		}
	}    
	(*c)->pilotId = pilotId;
	g_free(prefix);
}

void 
save_configuration(ConduitCfg *c) 
{
	gchar *prefix;
	g_return_if_fail(c!=NULL);
       	
	prefix= g_strdup_printf("/gnome-pilot.d/backup-conduit/Pilot_%u/",c->pilotId);
	
#ifdef BC_DEBUG
	fprintf(stderr,"backup_conduit: savecfg: prefix = %s\n",prefix);
#endif
	
	gnome_config_push_prefix(prefix);
	gnome_config_set_string("backup_dir",c->backup_dir);
	gnome_config_set_bool("updated_only",c->updated_only);
	gnome_config_set_bool("remove_deleted",c->remove_deleted);
	gnome_config_pop_prefix();
	gnome_config_sync();
	gnome_config_drop_all();
	g_free(prefix);
}
static void 
copy_configuration(ConduitCfg *d, ConduitCfg *c)
{
        g_return_if_fail(c!=NULL);
        g_return_if_fail(d!=NULL);
	if(d->backup_dir) g_free(d->backup_dir);
	d->backup_dir = g_strdup(c->backup_dir);
	d->remove_deleted = c->remove_deleted;
	d->updated_only = c->updated_only;
	d->pilotId = c->pilotId;
	d->child = c->child;
	if(d->exclude_files) g_list_free(d->exclude_files);
	d->exclude_files = g_list_copy(c->exclude_files);
	if(d->files_in_backup) g_list_free(d->files_in_backup);
	d->files_in_backup = g_list_copy(c->files_in_backup);
}

static ConduitCfg*
dupe_configuration(ConduitCfg *c) 
{
	ConduitCfg *d;
	g_return_val_if_fail(c!=NULL,NULL);
	d = g_new0(ConduitCfg,1);
	copy_configuration(d,c);
	return d;
}

/** this method frees all data from the conduit config */
void 
destroy_configuration(ConduitCfg **c) 
{
	g_return_if_fail(c!=NULL);
	g_return_if_fail(*c!=NULL);

	if((*c)->remove_deleted) {
		g_list_free((*c)->files_in_backup);
	}
	
	g_list_free((*c)->exclude_files);
	g_free((*c)->backup_dir);
	g_free(*c);
	*c = NULL;
}

