#include "obgtkCList.h"

@implementation Gtk_CList
- castGtkCList:(GtkCList *) castitem
{
  gtkclist = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- initWithCListInfo:(gint) ncolumns
{
  return [self castGtkCList:GTK_CLIST(gtk_clist_new(ncolumns))];
}

- initWithCListInfoTitles:(gint) ncolumns
		   Titles:(const gchar **)titles 
{
  return [self
	   castGtkCList:GTK_CLIST(gtk_clist_new_with_titles(ncolumns,
							    (char **)titles))];
}

- set_selection_mode:(GtkSelectionMode) mode
{
  gtk_clist_set_selection_mode(gtkclist, mode);
  return self;
}

- freeze
{
  gtk_clist_freeze(gtkclist);
  return self;
}

- thaw
{
  gtk_clist_thaw(gtkclist);
  return self;
}

- set_column_title:(gint) column
		  :(gchar *) title
{
  gtk_clist_set_column_title(gtkclist, column, title);
  return self;
}

- set_column_widget:(gint) column
		   :(Gtk_Widget *) widget
{
  gtk_clist_set_column_widget(gtkclist, column, widget->gtkwidget);
  return self;
}

- set_column_justification:(gint) column
			  :(GtkJustification) justification
{
  gtk_clist_set_column_justification(gtkclist, column, justification);
  return self;
}

- set_column_width:(gint) column
		  :(gint) width
{
  gtk_clist_set_column_width(gtkclist, column, width);
  return self;
}

- set_row_height:(gint) height
{
  gtk_clist_set_row_height(gtkclist, height);
  return self;
}

- moveto:(gint) row
	:(gint) column
	:(gfloat) row_align
	:(gfloat) col_align
{
  gtk_clist_moveto(gtkclist, row, column, row_align, col_align);
  return self;
}

- set_text:(gint) row
	  :(gint) column
	  :(gchar *) text
{
  gtk_clist_set_text(gtkclist, row, column, text);
  return self;
}

- set_pixmap:(gint) row
	    :(gint) column
	    :(GdkPixmap *) pixmap
	    :(GdkBitmap *) mask
{
  gtk_clist_set_pixmap(gtkclist, row, column, pixmap, mask);
  return self;
}

- set_pixtext:(gint) row
	     :(gint) column
	     :(gchar *) text
	     :(guint8) spacing
	     :(GdkPixmap *) pixmap
	     :(GdkBitmap *) mask
{
  gtk_clist_set_pixtext(gtkclist,
			row, column, text, spacing, pixmap, mask);
  return self;
}

- set_foreground:(gint) row
		:(GdkColor *) color
{
  gtk_clist_set_foreground(gtkclist, row, color);
  return self;
}

- set_background:(gint) row
		:(GdkColor *) color
{
  gtk_clist_set_background(gtkclist, row, color);
  return self;
}

- set_shift:(gint) row
	   :(gint) column
	   :(gint) vertical
	   :(gint) horizontal
{
  gtk_clist_set_shift(gtkclist, row, column, vertical, horizontal);
  return self;
}

- (gint)appendCListRow:(const gchar **) text
{
  return gtk_clist_append(gtkclist, (char **)text);
}

- insertCListRow:(gint) row
		:(const gchar **) text
{
  gtk_clist_insert(gtkclist, row, (char **)text);
  return self;
}

- removeCListRow:(gint) row
{
  gtk_clist_remove(gtkclist, row);
  return self;
}

- set_row_data_full:(gint) row
	    rowData:(gpointer) data
    destroyCallback:(GtkDestroyNotify) destroy
{
  gtk_clist_set_row_data_full(gtkclist, row, data, destroy);
  return self;
}

- set_row_data:(gint) row
       rowData:(gpointer) data
{
  gtk_clist_set_row_data(gtkclist, row, data);
  return self;
}

- (gpointer) get_row_data:(gint) row
{
  return gtk_clist_get_row_data(gtkclist, row);
}

- select_row:(gint) row
	    :(gint) column
{
  gtk_clist_select_row(gtkclist, row, column);
  return self;
}

- unselect_row:(gint) row
	      :(gint) column
{
  gtk_clist_unselect_row(gtkclist, row, column);
  return self;
}

- clear
{
  gtk_clist_clear(gtkclist);
  return self;
}


- column_titles_show
{
  return self;
}

- column_titles_hide;
{
  return self;
}

- column_title_active:(gint) column;
{
  gtk_clist_column_title_active(gtkclist, column);
  return self;
}

- column_title_passive:(gint) column;
{
  gtk_clist_column_title_passive(gtkclist, column);
  return self;
}

- column_titles_active
{
  gtk_clist_column_titles_active(gtkclist);
  return self;
}

- column_titles_passive
{
  gtk_clist_column_titles_passive(gtkclist);
  return self;
}

- (GtkVisibility) row_is_visible:(gint) row
{
  return gtk_clist_row_is_visible(gtkclist, row);
}

- (GtkCellType) get_cell_type:(gint) row :(gint) column
{
  return gtk_clist_get_cell_type(gtkclist, row, column);
}

- (gint)get_text:(gint) row
		:(gint) column
	 getText:(gchar **) text
{
  return gtk_clist_get_text(gtkclist, row, column, text);
}

- (gint) get_pixmap:(gint) row :(gint) column
	  getPixmap:(GdkPixmap **) pixmap
	    getMask:(GdkBitmap **) mask
{
  return gtk_clist_get_pixmap(gtkclist, row, column, pixmap, mask);
}

- (gint) get_pixtext:(gint) row :(gint) column
	     getText:(gchar **) text
	  getSpacing:(guint8 *) spacing
	  getPixmap:(GdkPixmap **) pixmap
	    getMask:(GdkBitmap **) mask
{
  return gtk_clist_get_pixtext(gtkclist, row, column, text, spacing, pixmap, mask);
}

- (gint) get_selection_info:(gint) x :(gint) y
		     getRow:(gint *) row
		  getColumn:(gint *) column
{
  return gtk_clist_get_selection_info(gtkclist, x, y, row, column);
}

- (gint) find_row_from_data:(gpointer) data
{
  return gtk_clist_find_row_from_data(gtkclist, data);
}

- undo_selection
{
  gtk_clist_undo_selection(gtkclist);
  return self;
}

- select_all
{
  gtk_clist_select_all(gtkclist);
  return self;
}

- unselect_all
{
  gtk_clist_unselect_all(gtkclist);
  return self;
}

- swap_rows:(gint) row1 :(gint) row2
{
  gtk_clist_swap_rows(gtkclist, row1, row2);
  return self;
}
@end
