#include "obgtkText.h"

@implementation Gtk_Text
- castGtkText:(GtkText *) castitem
{
  gtktext = castitem;
  return [super castGtkEditable:GTK_EDITABLE(castitem)];
}

- init
{
  return [self initWithAdjustments:[Gtk_Adjustment new] adjV:[Gtk_Adjustment new]];
}

- initWithAdjustments:(Gtk_Adjustment *) hadjustment
		    adjV:(Gtk_Adjustment *) vadjustment
{
  return [self castGtkText:GTK_TEXT(gtk_text_new(GTK_ADJUSTMENT([hadjustment getGtkObject]),
						 GTK_ADJUSTMENT([vadjustment getGtkObject])))];
}

- set_adjustments:(id) hadjustment
	     adjV:(id) vadjustment
{
  gtk_text_set_adjustments(gtktext,
			   GTK_ADJUSTMENT([hadjustment getGtkObject]),
			   GTK_ADJUSTMENT([vadjustment getGtkObject]));
  return self;
}

- set_editable:(gint) editable
{
  gtk_text_set_editable(gtktext, editable);
  return self;
}

- set_point:(gint) index
{
  gtk_text_set_point(gtktext, index);
  return self;
}

- (guint) get_point;
{
  return gtk_text_get_point(gtktext);
}

- (guint) get_length
{
  return gtk_text_get_length(gtktext);
}

- freeze
{
  gtk_text_freeze(gtktext);
  return self;
}

- thaw
{
  gtk_text_thaw(gtktext);
  return self;
}

- insert :(GdkFont *) font
    colFg:(GdkColor *) fore
    colBg:(GdkColor *) back
 insChars:(const char *) chars
   insLen:(gint) length
{
  gtk_text_insert(gtktext, font, fore, back, chars, length);
  return self;
}

- (gint) backward_delete:(guint) nchars
{
  return gtk_text_backward_delete(gtktext, nchars);
}

- (gint) forward_delete:(guint) nchars
{
  return gtk_text_forward_delete(gtktext, nchars);
}

- set_word_wrap:(gint) word_wrap
{
  gtk_text_set_word_wrap(gtktext, word_wrap);
  return self;
}
@end
