#include "obgtkCombo.h"
#include "obgtkItem.h"

@implementation Gtk_Combo

- castGtkCombo:(GtkCombo *) castitem
{
  gtkcombo = castitem;
  return [super castGtkHBox:GTK_HBOX(castitem)];
}

- init
{
  return [self castGtkCombo:GTK_COMBO(gtk_combo_new())];
}

- set_value_in_list:(gint) val
	  okIfEmpty:(gint) ok_if_empty
{
  gtk_combo_set_value_in_list(gtkcombo, val, ok_if_empty);
  return self;
}

- set_use_arrows:(gint) val
{
  gtk_combo_set_use_arrows(gtkcombo, val);
  return self;
}

- set_use_arrows_always:(gint) val
{
  gtk_combo_set_use_arrows_always(gtkcombo, val);
  return self;
}

- set_case_sensitive:(gint) val
{
  gtk_combo_set_case_sensitive(gtkcombo, val);
  return self;
}

- set_item_string:(id) item
	itemValue:(const gchar *) item_value
{
  gtk_combo_set_item_string(gtkcombo, GTK_ITEM([item getGtkObject]), item_value);
  return self;
}

- set_popdown_strings:(GList *) strings
{
  gtk_combo_set_popdown_strings(gtkcombo, strings);
  return self;
}
@end
