/* obgtkCalendar.m: Copyright (C) 1998 Free Software Foundation
 * Objective-C wrappings for GNOME UI routines.
 * Written by: Michael Hanni <mhanni@sprintmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "obgtkCalendar.h"

@implementation Gtk_Calendar
- init
{
  return [self castGtkCalendar:GTK_CALENDAR(gtk_calendar_new())];
}

- castGtkCalendar:(GtkCalendar *) castitem
{
  gtkcalendar = castitem;
  return [super castGtkWidget:GTK_WIDGET(castitem)];
}

- (gint) select_month:(gint) month
	      :(gint) year
{
  return (gtk_calendar_select_month(gtkcalendar, month, year));
}

- select_day:(gint) day
{
  gtk_calendar_select_day(gtkcalendar, day);
  return self;
}

- (gint) mark_day:(gint) day
{
  return (gtk_calendar_mark_day(gtkcalendar, day));
}

- (gint) unmark_day:(gint) day
{
  return (gtk_calendar_unmark_day(gtkcalendar, day));
}

- clear_marks
{
  gtk_calendar_clear_marks(gtkcalendar);
  return self;
}


- display_options:(GtkCalendarDisplayOptions) flags
{
  gtk_calendar_display_options(gtkcalendar, flags);
  return self;
}

- get_date:(gint *) year
	  :(gint *) month
	  :(gint *) day
{
  gtk_calendar_get_date(gtkcalendar, year, month, day);
  return self;
}

- freeze
{
  gtk_calendar_freeze(gtkcalendar);
  return self;
}

- thaw
{
  gtk_calendar_thaw(gtkcalendar);
  return self;
}
@end
