# Note that this is NOT a relocatable package
%define ver      0.17
%define rel      1
%define prefix   /usr

Summary: GNOME linuxconf front end
Name: gnome-linuxconf
Version: %ver
Release: %rel
Copyright: GPL
Group: X11/Utilities
Source: gnome-linuxconf-%{ver}.tar.gz
BuildRoot: /tmp/gnome-linuxconf-root
URL: http://www.gnome.org
Conflicts: linuxconf < 1.12r2

%description
Graphical user interface for the linuxconf configuration system.


%changelog
* Sun Feb 07 1999 Michael Johnson <johnsonm@redhat.com>
- New version now builds against Gtk 1.1.15 as well

* Mon Jan 25 1999 Michael Johnson <johnsonm@redhat.com>
- new improved version, should build both with GNOME 0.20/Gtk 1.0.x
  and with GNOME 0.99.x/Gtk 1.1.x

* Thu Oct 29 1998 Michael Johnson <johnsonm@redhat.com>
- imported back into official gnome tree, new version to celebrate!

* Thu Oct 01 1998 Michael K. Johnson <johnsonm@redhat.com>
- library fix

* Mon Sep 28 1998 Michael K. Johnson <johnsonm@redhat.com>
- fixed lots of bugs, now has treemenu mode

* Thu May 07 1998 Michael K. Johnson <johnsonm@redhat.com>
- linuxconf 1.11r11 handles fast connections appropriately.

* Tue May 05 1998 Michael K. Johnson <johnsonm@redhat.com>
- ignore SIGTSTP to work around suspected gtk bug
- fix use of vsnprintf()
- fix port 98 remadmin connections
- fixed resizing bug without completely changing layout

* Mon May 04 1998 Michael K. Johnson <johnsonm@redhat.com>
- fixed resizing bug
- added wmconfig entry for linuxconf

* Sat May 02 1998 Michael K. Johnson <johnsonm@redhat.com>
- fixed radio buttons, deal with "rich text"
- improved justification follows remadmin standard more closely

* Fri May 01 1998 Michael K. Johnson <johnsonm@redhat.com>
- fixes radio buttons and combo boxes
- work around small gnome problems

* Wed Apr 29 1998 Michael K. Johnson <johnsonm@redhat.com>
- takes title widths into account, so works with 0-length clists

* Thu Apr 16 1998 Michael K. Johnson <johnsonm@redhat.com>
- Now works with linuxconf 1.10r21
- Fixed a few more display problems.

* Wed Apr 15 1998 Michael K. Johnson <johnsonm@redhat.com>
- New io engine, some other improvements, make this really usable.

* Thu Apr 09 1998 Michael K. Johnson <johnsonm@redhat.com>
- Make a linuxconf-only package.  Final intent is to split gnome
  packages out more finely-grained than the current CVS tree.

* Mon Mar 16 1998 Marc Ewing <marc@redhat.com>
- Integrate into gnome-admin CVS source tree

%prep
%setup
if [ -x ./configure ] ; then
  ./configure --prefix=%{prefix}
else
  ./autogen.sh --prefix=%{prefix}
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{prefix}/bin
install -m 755 gnome-linuxconf $RPM_BUILD_ROOT%{prefix}/bin
mkdir -p $RPM_BUILD_ROOT%{prefix}/lib/rhs/control-panel/
install -m 644 linuxconf.xpm $RPM_BUILD_ROOT%{prefix}/lib/rhs/control-panel/
install -m 755 linuxconf.init $RPM_BUILD_ROOT%{prefix}/lib/rhs/control-panel/
mkdir -p $RPM_BUILD_ROOT/etc/X11/wmconfig
install -m 600 linuxconf.wmconfig $RPM_BUILD_ROOT/etc/X11/wmconfig/linuxconf

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files

%{prefix}/bin/gnome-linuxconf
%{prefix}/lib/rhs/control-panel/*
/etc/X11/wmconfig/linuxconf
