<?xml version="1.0" encoding="UTF-8"?>
<xslt:stylesheet xmlns:xslt="http://www.w3.org/1999/XSL/Transform" xmlns:msg="http://www.gnome.org/~shaunm/gnome-doc-utils/xsl-format" version="1.0">
  <title xmlns="http://www.gnome.org/~shaunm/xsldoc">Format Templates</title>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.citetitle</name>
    <purpose>
    Format a <xmltag>citetitle</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <sgmltag>citetitle</sgmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label, extracted from the
      <sgmltag class="attribute">pubwork</sgmltag> attribute
    </purpose>
    </parameter>
    <description>
      <para>This template used for formatting the <sgmltag>citetitle</sgmltag>
    element in DocBook.  The <sgmltag>citetitle</sgmltag> element has a
    <sgmltag class="attribute">pubwork</sgmltag> attribute that can be set
    to one of the following values:
    <literal>article</literal>,      <literal>bbs</literal>,
    <literal>book</literal>,         <literal>cdrom</literal>,
    <literal>chapter</literal>,      <literal>dvd</literal>,
    <literal>emailmessage</literal>, <literal>gopher</literal>,
    <literal>journal</literal>,      <literal>manuscript</literal>,
    <literal>newsposting</literal>,  <literal>part</literal>,
    <literal>refentry</literal>,     <literal>section</literal>,
    <literal>series</literal>,       <literal>set</literal>,
    <literal>webpage</literal>,      <literal>wiki</literal>.
    This template allows multiple role format strings, using the value of
    <sgmltag class="attribute">pubwork</sgmltag> as the role.  Translators
    can use this to customize the appearance of a cited title based on the
    type of document being cited.  The default formatting is as follows:</para>
      <programlisting>
&lt;msg:msgstr role="article"&gt;“%t{node}”&lt;/msg:msgstr&gt;
&lt;msg:msgstr&gt;&lt;i&gt;%t{node}&lt;/i&gt;&lt;/msg:msgstr&gt;</programlisting>
      <para>This puts the title of an article citation in quotes.  For all other
    types of works, the title is simply italicized.</para>
    </description>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>citetitle</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.citetitle">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>“</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>
  </xslt:text>
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
        <xslt:text>
  </xslt:text>
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
        <xslt:text>
</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.citetitle</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitattittel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.साइटशीर्षक</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitattittel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>“</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citattitel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.çağrıbaşlığı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>Trích dẫn tên</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.outer</name>
    <purpose>
    Format a <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>quote</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.quote.outer">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>"</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>"</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.kutip.luar</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitat.ytre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदधृत वाक्य.बाहिरी</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitat.ytre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.yttre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.aktarım.dışa</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.inner</name>
    <purpose>
    Format a nested <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>quote</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.quote.inner">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>,,</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>''</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.kutip.dalam</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitat.indre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदधृत वाक्य.भित्री</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitat.indre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.inre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.aktarım.içe</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>‹</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>›</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.appendix.label</name>
    <purpose>
    Format the label for a <xmltag>appendix</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>appendix</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.appendix.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Dodatak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Dodatak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apêndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.appendix label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Приложение </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Příloha </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Anhang </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Anhang </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apéndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Lisa </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Liite </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.tambahan.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as priedas</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tillegg.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.एपेन्डिक्स.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tillegg.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apêndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Anexa </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Príloha </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Додатак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Додатак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.appendix.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.ek.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Phụ lục </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.chapter.label</name>
    <purpose>
    Format the label for a <xmltag>chapter</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>chapter</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.chapter.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Glava </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Glava </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.chapter label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitola </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Kapitel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. peatükk</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kappale </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.bab.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as skyrius</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapittel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.अध्याय.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapittel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capitolul </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitola </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapitel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.bölüm.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Chương </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.label</name>
    <purpose>
    Format the label for a <xmltag>example</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>example</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.example.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Primer </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Primer </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.example label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Пример </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Příklad </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Beispiel </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Beispiel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Ejemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Näide </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Esimerkki </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text>. Példa</xslt:text>
            </xslt:element>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Példa</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.contoh.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as pavyzdys</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.eksempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.उदारण.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.eksempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplul </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Príklad </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Пример </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Пример </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.exempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.örnek.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Lời thí dụ </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Example </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Example </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.label</name>
    <purpose>
    Format the label for a <xmltag>figure</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>figure</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.figure.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Slika </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Slika </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figure label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Фигура </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Obrázek </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Abbildung </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Abbildung </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Joonis </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kuva </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text>. Kép</xslt:text>
            </xslt:element>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Kép</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.gambar.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as paveikslėlis</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.रेखाचित्र.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Imagem </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Obrázok </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Слика </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Слика </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.şekil.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Hình </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Figure </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figure </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.manvolnum</name>
    <purpose>
    Format a <xmltag>manvolnum</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>manvolnum</xmltag> element to format
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.manvolnum">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.manvolnum</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.volum</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.मानभोल्नम</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.volum</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.part.label</name>
    <purpose>
    Format the label for a <xmltag>part</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>part</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.part.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Deo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Deo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'en' and $lang_region = 'CA'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'en' and $lang_region = 'GB'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Parte </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'TW'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ca'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Část </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Teil </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Teil </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'el'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Parte </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Osa</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Osa </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'gu'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>.</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> Rész: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Rész</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.bagian.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ja'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ko'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-a dalis</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.del.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.अध्याय.तह</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nl'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.del.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pa'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Secção </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Partea </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Časť </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sq'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Део </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Део </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.del.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.parça.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'uk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.part.label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Phần </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Part </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Part </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.refentry.label</name>
    <purpose>
    Format the label for a <xmltag>refentry</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>refentry</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.refentry.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.refentry label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.refentry.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.referanseoppføring.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.रिफेन्ट्री.तह</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.referanseoppføring.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.refpost.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.refgirişi.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.section.label</name>
    <purpose>
    Format the label for a <xmltag>section</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>section</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.section.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Odeljak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Odeljak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Seção </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.section label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Дял </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Oddíl </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Abschnitt </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Abschnitt </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Sección </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. lõik</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Luku </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.bagian.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as skyrius</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.avsnitt.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.सेक्सन.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.avsnitt.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Secção </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Secţiunea </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Oddiel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Одељак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Одељак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.avsnitt.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kısım.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tiết đoạn </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Section </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Section </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.label</name>
    <purpose>
    Format the label for a <xmltag>table</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>table</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.table.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Tabela </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabela </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabela </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.table label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Таблица </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabulka </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Tabelle </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabelle </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabla </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabel </xslt:text>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Taulukko </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text>. Táblázat</xslt:text>
            </xslt:element>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Táblázat</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.tabel.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-a lentelė</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tabell.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.तालिका.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tabell.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabela </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabela </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Tabuľka </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Табела </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Табела </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tabell.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tablo.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Bảng </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Table </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Table </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number</name>
    <purpose>
    Format the number for a <xmltag>example</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.example.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.contoh.nomor</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.eksempel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदाहरण.नम्बर</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.eksempel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.exempel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.örnek.sayı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number.flat</name>
    <purpose>
    Format the number for a <xmltag>example</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.example.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.contoh.nomor.rata</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.eksempel.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदाहरण.नम्बर.समतल</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.eksempel.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.exempel.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.örnek.sayı.düz</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number</name>
    <purpose>
    Format the number for a <xmltag>figure</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.figure.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.gambar.nomor</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.figur.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.रेखाचित्र.नम्बर</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.figur.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>"</xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.figur.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.şekil.sayı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number.flat</name>
    <purpose>
    Format the number for a <xmltag>figure</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.figure.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.gambar.nomor.rata</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.figur.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.रेखाचित्र.नम्बर.समतल</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.figur.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>"</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.figur.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.şekil.sayı.düz</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.part.number</name>
    <purpose>
    Format the number for a <xmltag>part</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.part.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.bagian.nomor</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.del.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.अध्याय.नम्बर</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.del.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.del.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.parça.sayı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number</name>
    <purpose>
    Format the number for a <xmltag>table</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.table.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.tabel.nomor</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.tabell.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.तालिका.नम्बर</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.tabell.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.tabell.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.tablo.sayı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number.flat</name>
    <purpose>
    Format the number for a <xmltag>table</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.table.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.tabel.nomor.rata</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.tabell.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.तालिका.नम्बर.समतल</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.tabell.nummer.flat</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.tabell.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.tablo.sayı.düz</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.tooltip.glossentry</name>
    <purpose>
    Format the tooltip for a link to a <xmltag>glossentry</xmltag>
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>glossentry</xmltag> element
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.tooltip.glossentry">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>Pročitajte definiciju za „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>Leia a definição de ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Виж дефиницията на „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Viz definici „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>Lesen Sie die Definition für „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>Lea la definición de «</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>Loe ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’ kirjeldust</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Lue sanan "</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>" määritelmä.</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>Olvassa el „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>” definícióját</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.tooltip.glossentry</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Skaityti „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“ aprašymą</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.verktøytips.ordbokoppføring</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उपकरण टिप.शब्दसंग्रह प्रबिष्टि</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.verktøytips.ordbokoppføring</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Ler a definição de ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>Vezi definiţia pentru „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Pozri definíciu „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>Прочитајте дефиницију за „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.verktygstips.ordlistepost</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.ipucu.sözlükgirişi</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>Đọc lời định nghĩa cho ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>Read the definition for ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.tooltip.mailto</name>
    <purpose>
    Format the tooltip for a link to a
    <systemitem role="protocol">mailto</systemitem> URI.
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The source node
    </purpose>
    </parameter>
    <parameter>
      <name>address</name>
      <purpose>
      The email address
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.tooltip.mailto">
    <xslt:param name="node"/>
    <xslt:param name="address"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>Pošaljite e-pismo na „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>Envie um e-mail para ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Пращане на писмо до „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Odeslat e-mail na „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>Senden Sie eine E-Mail an „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>Enviar un correo-e a «</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>Saada kiri aadressil: ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Lähetä sähköpostia osoitteeseen "</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>"</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>Küldjön e-mailt „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>” címre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.tooltip.suratke</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Siųsti „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“ el.laišką</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.verktøytips.mailto</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उपकरणटिप.माइल्टो</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.verktøytips.mailto</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Enviar um email para ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>Trimite email la „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Odoslať e-mail pre „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>Пошаљите е-писмо на „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.verktygstips.e-postatill</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.ipucu.postaalıcısı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>Gởi thư điện tử cho ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>Send email to ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
</xslt:stylesheet>
