/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_SOURCE_VIEWER_H__
#define __GDF_SOURCE_VIEWER_H__

#include <gnome.h>
#include <gdf.h>

BEGIN_GNOME_DECLS

typedef struct _GdfSourceViewer      GdfSourceViewer;
typedef struct _GdfSourceViewerClass GdfSourceViewerClass;
typedef struct _GdfSourceViewerPriv  GdfSourceViewerPriv;

#define GDF_SOURCE_VIEWER_TYPE        (gdf_source_viewer_get_type ())
#define GDF_SOURCE_VIEWER(o)          (GTK_CHECK_CAST ((o), GDF_SOURCE_VIEWER_TYPE, GdfSourceViewer))
#define GDF_SOURCE_VIEWER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GDF_SOURCE_VIEWER_TYPE, GdfSourceViewerClass))
#define GDF_IS_SOURCE_VIEWER(o)       (GTK_CHECK_TYPE ((o), GDF_SOURCE_VIEWER_TYPE))
#define GDF_IS_SOURCE_VIEWER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GDF_SOURCE_VIEWER_TYPE))

struct _GdfSourceViewer {
    GtkFrame frame;
	
    gchar *source_path;
    gint current_line;

    GdfSourceViewerPriv *priv;
};

struct _GdfSourceViewerClass {
    GtkFrameClass parent_class;
};

GtkType gdf_source_viewer_get_type (void);
GtkWidget *gdf_source_viewer_new (const gchar *source_path);

void gdf_source_viewer_add_breakpoint (GdfSourceViewer *sv,
				       gint bp_num, gint line_num, 
				       gboolean enabled);
void gdf_source_viewer_enable_breakpoint (GdfSourceViewer *sv, gint bp_num,
					  gboolean enabled);
void gdf_source_viewer_remove_breakpoint (GdfSourceViewer *sv, gint bp_num);
gboolean gdf_source_viewer_has_breakpoint (GdfSourceViewer *sv, gint bp_num);
void gdf_source_viewer_view_line (GdfSourceViewer *sv, gint line_num);
void gdf_source_viewer_set_current_line (GdfSourceViewer *sv, gint line_num);
void gdf_source_viewer_clear_current_line (GdfSourceViewer *sv);
void gdf_source_viewer_set_debugger (GdfSourceViewer *sv, 
                                     GdfDebuggerClient *dbg);

END_GNOME_DECLS
#endif
